package ie.ucd.sixth.core.cyber.utils.geocode;

import ie.ucd.sixth.core.cyber.utils.UrlRequester;
import ie.ucd.sixth.core.cyber.utils.parsers.XmlToMapConverter;

import java.util.Map;
import java.util.Set;

/**
 * this mapquest geocoder has unlimited API calls 
 * @author Olga
 *
 */
public class Geocoder {
	
	public static Map<String, String> geocode(String locationName){
		
		System.out.println("Geo loc: "+locationName);
		locationName.replace(" ", "%20");
//		String url2 = "http://nominatim.openstreetmap.org/search?q="+locationName+"&format=xml&polygon=1&addressdetails=1";
		String url = "http://open.mapquestapi.com/nominatim/v1/search.php?format=xml&q="+locationName;
		UrlRequester requester = new UrlRequester();
		String response = requester.makeRequest(url);
		return new XmlToMapConverter().parse(response);
	}
	
	public static Map<String, String> reverseGeocode(String latitude, String longitude){
//		String url = "http://nominatim.openstreetmap.org/reverse?format=xml&lat=52.5487429714954&lon=-1.81602098644987&zoom=18&addressdetails=1";
		String url2 = "http://open.mapquestapi.com/nominatim/v1/reverse.php?format=xml&lat="+latitude+"&lon="+longitude;
		UrlRequester requester = new UrlRequester();
		String response = requester.makeRequest(url2);
		return new XmlToMapConverter().parse(response);
	}
	
	
	
	public static void main(String[] args){
		String brokenUrl ="http://where.yahooapis.com/geocode?q=UK&appid=FDzIWXfV34HtzjVF8_npsmwe0YQI3AgcPQN3FhtIBPqyLfce7T_.9.3Qgd9CIJZHgk5sjAmunFwco0Vl4DPtNejMZ4tXggM-";
//		Map<String, String> result = Geocoder.geocode("wales");
		Map<String, String> result = Geocoder.reverseGeocode("51.52143", "-0.162714");
		Set<String> resultSet = result.keySet();
		for (String string : resultSet) {
			System.out.println("key: " +string+ "    value: "+result.get(string));
		}
		
		//key: searchresults.place.0.boundingboxvalue: 53.1894299,53.5094299,-6.4200969,-6.1000969

		String countyPath = "reversegeocode.addressparts.county";
	
		if(result.containsKey(countyPath)){
			System.out.println(result.get(countyPath));
		}else{
			System.out.println("nope");
		} 
	}

}
