package ie.ucd.sixth.core.cyber.utils.geocode;

public class BoundingBox{
    public double swLatitude  = 0.0;
    public double swLongitude = 0.0;
    public double neLatitude  = 0.0;
    public double neLongitude = 0.0;

    /*************************************************************************
    Constructor.
    @param bboxSpecification A comma-separated string containing the 
        southwest latitude, soutwest longitude, northest latitude, and 
        northest longitude.
    *************************************************************************/
    public BoundingBox(String bboxSpecification)
    {
        String tokens[] = bboxSpecification.split("(?:,\\s*)+");

        if (tokens.length != 4)
        {
            throw new IllegalArgumentException(
                String.format("Expected 4 values in bbox string but found %d: %s\n",
                tokens.length, bboxSpecification));
        }
		//wales bbox: 51.2290265[SW lat],53.635[NE lat],-5.8077297[SW lon],-2.6498626[NE lon]

        swLatitude =  Double.parseDouble(tokens[0]);
        swLongitude = Double.parseDouble(tokens[2]);
        neLatitude =  Double.parseDouble(tokens[1]);
        neLongitude = Double.parseDouble(tokens[3]);
    }

    @Override
    public String toString()
    {
        return String.format("swLatitude=%f, swLongitude=%f, neLatitude=%f, neLongitude=%f", 
                swLatitude, swLongitude, neLatitude, neLongitude);
    }

    /*************************************************************************
    Checks if the bounding box contains the latitude and longitude. Note that
    the function works if the box contains the prime merdian but does not
    work if it contains one of the poles. 
    *************************************************************************/
    public boolean contains(double latitude, double longitude)
    {
        boolean longitudeContained = false;
        boolean latitudeContained = false;

        // Check if the bbox contains the prime meridian (longitude 0.0).
        if (swLongitude < neLongitude)
        {
            if (swLongitude < longitude && longitude < neLongitude)
            {
                longitudeContained = true;
            }
        }
        else
        {
            // Contains prime meridian.
            if ((0 < longitude && longitude < neLongitude) ||
                (swLongitude < longitude && longitude < 0))
            {
                longitudeContained = true;
            }
        }

        if (swLatitude < neLatitude)
        {
            if (swLatitude < latitude && latitude < neLatitude)
            {

                latitudeContained = true;
            }
        }
        else 
        {
            // The poles. Don't care.
        }     		
        		
        return (longitudeContained && latitudeContained);
    }

    public static void main(String[] args)
    {
        BoundingBox bbox;
        double latitude = 0;
        double longitude = 0;

        bbox = new BoundingBox("37.43,-122.38,37.89,-121.98");
        latitude = 37.5;
        longitude = -122.0;

        System.out.printf("bbox (%s) contains %f, %f: %s\n", 
            bbox, latitude, longitude, bbox.contains(latitude, longitude));

        bbox = new BoundingBox("50.99, -2.0, 54, 1.0");
        latitude = 51.0;
        longitude = 0.1;

        System.out.printf("bbox (%s) contains %f, %f: %s\n", 
            bbox, latitude, longitude, bbox.contains(latitude, longitude));
    }
}