package ie.ucd.sixth.core.cyber.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.imageio.ImageIO;

public class UrlRequester {
	private static final Logger logger = Logger.getLogger(UrlRequester.class.getName());
	static {
		logger.setLevel(Level.OFF);
	}
	
	public Image getImage(String urlRequestString){
		BufferedImage img=null;
		try {
			img = ImageIO.read(new URL(urlRequestString));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return img;
	}
	
	public void postTest(String request, Map<String, Object> params){
        URL url;
		try {
			url = new URL(request);
	
//        Map<String,Object> params = new LinkedHashMap<String, Object>();
//        params.put("apikey", FLOOD_API_KEY);
//        params.put("persist", "1");
     
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String,Object> param : params.entrySet()) {
            if (postData.length() != 0) postData.append('&');
            postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
            postData.append('=');
            postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        byte[] postDataBytes = postData.toString().getBytes("UTF-8");

        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);

        Reader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        for (int c; (c = in.read()) >= 0; System.out.print((char)c));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void postRequest(String urlRequestString, Map<String, String> postData){
		try {
			// Construct data
			
			String data =  "";
			for(Entry<String, String> entry : postData.entrySet()){
				data+=URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
			}

			 // Send data
		    URL url = new URL(urlRequestString);
		    URLConnection conn = url.openConnection();
		    conn.setDoOutput(true);
		    OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
		    wr.write(data);
		    wr.flush();

		    // Get the response
		    BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
		    String line;
		    while ((line = rd.readLine()) != null) {
		        // Process line...
		    	System.out.println("line: " +line);
		    }
		    wr.close();
		    rd.close();
			
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public String makeRequest(String urlRequestString, Map<String, String> requestParams){
		logger.info("cyber core requester.... making request: " +urlRequestString);
		String response = "";
		urlRequestString = urlEncodeString(urlRequestString);
		try {
			//send request
			URL url = new URL(urlRequestString);
			URLConnection urlConnection =  url.openConnection();
			urlConnection.setDoInput(true);
			if(requestParams!=null && !requestParams.isEmpty()){
				for (String param : requestParams.keySet()) {
					urlConnection.setRequestProperty(param, requestParams.get(param));
				}
			}
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
			for (String string : headerFields.keySet()) {
				System.out.println("header field: " +string);
				for (String  h : headerFields.get(string)) {
					System.out.println("field value: " +h);
					
				}
				
			}
			String output = "";


			/*
			 * receive repsonse 
			 */
			while((output = input.readLine()) !=null){
				response+=output;
				System.out.println("response... " +response);
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.out.println(urlRequestString);
			return null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.out.println(urlRequestString);
			return null;
		} catch(Exception e){
			e.printStackTrace();
			System.out.println(urlRequestString);
			return null;
		}
		return response;
	}
	
	public String makeRequest(String urlRequestString){
		logger.info("cyber core requester.... making request: " +urlRequestString);
		String response = "";
		urlRequestString = urlEncodeString(urlRequestString);
		try {
			//send request
			URL url = new URL(urlRequestString);
			URLConnection urlConnection =  url.openConnection();
			urlConnection.setDoInput(true);
			//receive response
			InputStream inStream = urlConnection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";


			/*
			 * receive repsonse 
			 */
			while((output = input.readLine()) !=null){
				response+=output;
			}

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.out.println(urlRequestString);
			return null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.out.println(urlRequestString);
			return null;
		} catch(Exception e){
			e.printStackTrace();
			System.out.println(urlRequestString);
			return null;
		}
		return response;
	}
	
	//TODO change this functionality to be performed using a transformer pipe
	private String urlEncodeString(String string){
		return string.replace(" ", "&20");
	}
	
	/*
	 * just for local testing
	 */
	public static void main(String[] args){
		UrlRequester test = new UrlRequester();
//		Map<String, String> map = new HashMap<String, String>();
//		map.put("apikey", "1cbe6b564e0f98379eefd6d4be8b9110c7fdc726");
//		map.put("text", "this is a big long string about how happy and delighted i am to be testing this wonderful api");
//		test.postRequest("http://access.alchemyapi.com/calls/text/TextGetTextSentiment", map);
		
		String url = "http://access.alchemyapi.com/calls/text/TextGetTextSentiment?apikey=8e7da7e74a5c9c5f70d9d160eafc317b99aaeba0&text=this is a big long string about how happy and delighted i am to be testing this wonderful api";
//		String url2 = "http://access.alchemyapi.com/calls/text/TextGetRankedKeywords?apikey=8e7da7e74a5c9c5f70d9d160eafc317b99aaeba0&text=this is a big long string about how happy and delighted i am to be testing this wonderful api&sentiment=1";
		
		System.out.println(test.makeRequest(url));
	
	
	}

}
