package ie.ucd.sixth.core.cyber.utils;

import java.text.Normalizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class TextParser {
	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);

	public String removeWhiteSpace(String text){
		return text.replaceAll("\\s", "");
	}
	
	public String removeStars(String text){
		return text.replaceAll("\\*", "");
	}
	
	public String removePercentSymbol(String text){
		return text.replaceAll("\\%", "");
	}
	
	public String replacePercentSymbol(String text){
		return text.replaceAll("\\%", "percent");
	}
	
	public String replaceAmpersand(String text){
		return text.replaceAll("\\&", "and");
	}
	
	public String replaceSlashWithUnderscore(String text){
		return text.replaceAll("\\/",  "_");
	}
	public String removeBrackets(String text){
		text = text.replaceAll("\\(", "");
		return text.replaceAll("\\)",  "");
	}
	
	public String prependNumbers(String text){
		return "REMOVE"+text;
	}
	
	public String deAccent(String text){
		String normalized = Normalizer.normalize(text, Normalizer.Form.NFD);
		Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
		return pattern.matcher(normalized).replaceAll("");
	}

	public String removeColons(String text) {
		text = text.replaceAll(":", "");
		return text;
	}
	
	public String makeXmlTagSafe(String text){
		
		boolean firstCharLetter = ((text.charAt(0) >= 'a') && (text.charAt(0) <= 'z')) ||((text.charAt(0) >= 'A') && (text.charAt(0) <= 'Z')); 
		
		String xmlText = removeWhiteSpace(text);
		xmlText = removeStars(xmlText);
		xmlText = replacePercentSymbol(xmlText);
		xmlText = replaceAmpersand(xmlText);
		xmlText = replaceSlashWithUnderscore(xmlText);
		xmlText = removeBrackets(xmlText);
		xmlText = deAccent(xmlText);
		xmlText = removeColons(xmlText);
		//xml tags cannot start with a number
		if(!firstCharLetter){
			xmlText = "remove_xml"+xmlText;

		}
		return xmlText;
	}
	


	public String makeXmlValueSafe(String text){
		String xmlText = removeStars(text);
		xmlText = replacePercentSymbol(xmlText);
		xmlText = replaceAmpersand(xmlText);
		
		
		return xmlText;
	}
	
	
//	public static void main(String[] args){
//		TextParser t = new TextParser();
//	}
}



