package ie.ucd.sixth.core.cyber.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

import javax.swing.text.html.HTMLEditorKit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * uses www.geobytes.com/iplocator.htm to retrieve location information relating to the host ip address
 * restrictions: 20 lookups per hour
 * 
 * TODO: write lookup results to file and check if detected ip matches that in file before sending lookup request
 */
public class IPAddressRetriever extends HTMLEditorKit{

	private String country = "";
	private String region = "";
	private String city = "";
	private String ipString = "";
	private String latitude = "";
	private String longitude = "";
	private String resultCertainty = "";

	private String xmlString;
	
	private final String FILE_NAME = "./ipInfo.txt"; //main cybersensorcore folder

	public IPAddressRetriever(){

	}

	public void getIP(){
		try {
			InetAddress thisIp = InetAddress.getLocalHost();
			ipString = thisIp.getHostAddress();

		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public String requestLocationInfo(){
		getIP();
		if(!fileHasIP()){

			String urlString = "http://www.geobytes.com/IpLocator.htm?GetLocation&template=php3.txt&IpAddress="+ipString; //geobytes url for requesting info based on ip
			HTMLParser parser = new HTMLParser(urlString);
			parser.parse();
			xmlString = parser.getXmlString();
			

			parseResponse(xmlString);
			writeToFile();
		}
		else{
			setXMLandVariablesFromFile();
		}

		return xmlString;

	}

	public void getLocationInfo(){
		String urlString = "http://www.geobytes.com/IpLocator.htm?GetLocation&template=php3.txt&IpAddress="+ipString;
		String response = "";
		try {
			URL url = new URL(urlString);
			URLConnection connection = url.openConnection();
			connection.setDoInput(true);

			//receive response
			InputStream inStream = connection.getInputStream();
			BufferedReader input = new BufferedReader(new InputStreamReader(inStream));

			String output = "";
			while((output = input.readLine()) !=null){
				response += output; //add response to response string

			}



		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	private void parseResponse(String xml){
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(xml));

			Document doc = db.parse(is);
			//parent node
			NodeList nodes = doc.getChildNodes();
			Element el = (Element) nodes.item(0);

			NodeList htmlNodes = el.getChildNodes();


			for(int i = 0; i< htmlNodes.getLength(); i++){
				Element childEl = (Element)htmlNodes.item(i);
				if(childEl.getNodeName() == "country"){
					country = childEl.getTextContent();
				}
				else if(childEl.getNodeName() == "region"){
					region = childEl.getTextContent();
				}
				else if(childEl.getNodeName() == "city"){

					city = childEl.getTextContent();

				}
				else if(childEl.getNodeName() == "ipString"){
					ipString = childEl.getTextContent();

				}
				else if(childEl.getNodeName() == "latitude"){
					latitude = childEl.getTextContent();
				}
				else if(childEl.getNodeName() == "longitude"){
					longitude = childEl.getTextContent();
				}
				else if(childEl.getNodeName() == "certainty"){
					resultCertainty = childEl.getTextContent();
				}

			}


		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	private boolean fileHasIP(){
		boolean IPExists = false;

		File file  = new File(FILE_NAME);
		if(file.exists()){ //if the file doesnt exist neither does the IP

			try {
				FileInputStream fileInputStream = new FileInputStream(FILE_NAME); //open file
				DataInputStream dataInputStream = new DataInputStream(fileInputStream);
				BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));

				String lineString= bufferedReader.readLine(); //we only need to read the first line of the file

				if(lineString.contains(ipString)){

					IPExists = true;
				}



			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		return IPExists;
	}

	private void writeToFile(){
		try {
			FileWriter fileWriter = new FileWriter(FILE_NAME); //create the file if it doesnt exist
			BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
			bufferedWriter.write("IP: " +ipString + "\n");
			bufferedWriter.write("Region: " +region + "\n");
			bufferedWriter.write("City: " +city + "\n");
			bufferedWriter.write("Country: "+country + "\n");
			bufferedWriter.write("Certainty: " +resultCertainty + "\n");

			bufferedWriter.close();


		} catch (IOException e) {

			e.printStackTrace();
		} 
	}

	/*
	 * in the case that the ip has already been resolved to a location we want to construct some xml to return
	 * fromt he request method having not made a new request
	 */
	private void setXMLandVariablesFromFile(){

		if(xmlString == null || !(xmlString.contains(ipString))){ //if xmlString has not been set or it doesnt already have the info for this IP

			FileInputStream fileInputStream;
			try {
				fileInputStream = new FileInputStream(FILE_NAME);

				DataInputStream dataInputStream = new DataInputStream(fileInputStream);
				BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));

				String lineString;
				while((lineString= bufferedReader.readLine())!=null ){ //read the file line by line

					if(lineString.contains("Region")){
						region = lineString.split(": ")[1]; //set the value part of the line to the region variable
					}
					if(lineString.contains("City")){
						city = lineString.split(": ")[1]; 
					}
					if(lineString.contains("Country")){
					
						country = lineString.split(": ")[1]; 
					}
					if(lineString.contains("Certainty")){
						resultCertainty = lineString.split(": ")[1]; 
					}
				}

				xmlString="<html>";
				xmlString+="<ip>"+ipString+"</ip>";
				xmlString+="<region>"+region+"</region>";
				xmlString+="<city>"+city+"</city>";
				xmlString+="<country>"+country+"</country>";
				xmlString+="<certainty>"+resultCertainty+"</certainty>";
				xmlString+="</html>";
				
				bufferedReader.close();

			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} //open file
			catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		
	}

	private void setCountry(String country){
		this.country = country;
	}

	private void setRegion(String region){
		this.region = region;
	}

	private void setCity(String city){
		this.city = city;
	}

	private void setIpString(String ipString) {
		this.ipString = ipString;
	}

	private void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	private void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	private void setResultCertainty(String resultCertainty) {
		this.resultCertainty = resultCertainty;
	}

	public String getCountry() {
		return country;
	}

	public String getRegion() {
		return region;
	}

	public String getCity() {
		return city;
	}

	public String getIpString() {
		return ipString;
	}

	public String getLatitude() {
		return latitude;
	}

	public String getLongitude() {
		return longitude;
	}

	public String getResultCertainty() {
		return resultCertainty;
	}

	/*
	 * just for testing
	 */
	public static void main(String[] args){
		IPAddressRetriever retreiver = new IPAddressRetriever();
		retreiver.requestLocationInfo();
	}



}
