package ie.ucd.sixth.core.cyber.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;

import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLParser extends HTMLEditorKit.ParserCallback {
	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);

	private String HTMLString = "";
	private String urlString = "";
	private ArrayList<String> attributesList;
	private String xmlString = "<html>";
	private String ipString = "";

	public HTMLParser(String urlString){
		this.urlString = urlString;
		this.ipString = ipString;
		attributesList = new ArrayList<String>();
	}
	
	public HTMLParser(String urlString, String ipString){
		this.urlString = urlString;
		attributesList = new ArrayList<String>();
	}

	public void parse(){
		ParserGetter kit = new ParserGetter();
		HTMLEditorKit.Parser parser = kit.getParser();
		HTMLEditorKit.ParserCallback callback = this;

		try {
			URL url = new URL(urlString);
			InputStream in = url.openStream();
			InputStreamReader r = new InputStreamReader(in);
			parser.parse(r, callback, false);


		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		generateXML();
	}



	@Override
	public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
		this.listAttributes(attributes);
	}

	private void listAttributes(AttributeSet attributes) {
		Enumeration e = attributes.getAttributeNames();
		while (e.hasMoreElements()) {
			Object name = e.nextElement();
			Object value = attributes.getAttribute(name);
			if (!attributes.containsAttribute(name.toString(), value)) {
				logger.severe("containsAttribute() fails");
			}
			if (!attributes.isDefined(name.toString())) {
				logger.severe("isDefined() fails");
			}
			String temp = name + "=" + value;
			attributesList.add(temp);
			
		}
		
	}
	
	private void generateXML(){

		xmlString+="<ip>"+ipString+"</ip>";
		
		for (int i = 0; i< attributesList.size()-1; i++) {
			String s = attributesList.get(i);
	
			if(s.startsWith("name")){
		
				xmlString+="<";
				String temp = s.split("=")[1]; // put what is after the equals as the tag name
				xmlString+=temp+">";
				String value = attributesList.get(i+1).split("=")[1];
				xmlString+=value+"</"+temp+">";
			}
		}
	}

	@Override
	public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
		this.listAttributes(attributes);
	}

	public ArrayList<String> getAttributesList() {
		return attributesList;
	}

	public String getXmlString() {
		return xmlString+="</html>";
	}
	
	

}
class ParserGetter extends HTMLEditorKit {
	@Override
	public HTMLEditorKit.Parser getParser() {
		return super.getParser();
	}
}