package ie.ucd.sixth.core.cyber.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class File_IO {

	private static final Logger logger = Logger.getLogger(File_IO.class.getName());
	
	static {
		logger.setLevel(Level.SEVERE);
	}	
	/*
	 * use for reading the entire file into a single string
	 */
	public String readFileStream(String filePath){
		String fileContent = "";
		InputStream is = getClass().getResourceAsStream(filePath);
		logger.info("reading file: " +(is!=null));
		if(is!=null){ 
			Writer writer = new StringWriter();
			char[] buffer = new char[1024];

			try {
				Reader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
				int n;
				while((n = reader.read(buffer)) != -1){
					writer.write(buffer, 0, n);
				}

				is.close();	
				fileContent = writer.toString();
				
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}			

		}
		logger.info("have file content: " +fileContent);
		return fileContent;
	}

	/*
	 * user for reading a file in line by line and storing each line in an arraylist
	 */
	public ArrayList<String> readFileStreamToList(String filePath){
		ArrayList<String> fileList = new ArrayList<String>();
		
		InputStream is = getClass().getResourceAsStream(filePath);
		logger.info("reading file: " +(is!=null));
		if(is!=null){ 
	
			try {
				BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
				
				String line;
				while((line = reader.readLine()) !=null){
					line = line.trim();
					logger.info("line: " +line+" line length: " +line.length() +" is line empty? " +line.isEmpty());
					if(!line.isEmpty()){ //ignore any lines that contain only whitespace
						fileList.add(line);
					}
	
				}

				is.close();	
				reader.close();
				
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}			

		}
		
		return fileList;
	}
	
//	public String readFile(String filePath){
//		String fileString = "";
//		try {
//			BufferedReader reader = new BufferedReader(new FileReader(filePath));
//			String line;
//			while((line = reader.readLine()) !=null){
//				fileString+=line;
//
//			}
//
//			reader.close();
//		} catch (FileNotFoundException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//
//
//		return fileString;
//	}


	public void writeStringToFile(String string, String file){
		try {
			BufferedWriter writer = new BufferedWriter(new FileWriter(file));
			writer.write(string);
			writer.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	
	/*
	 * just for local testing
	 */
	public static void main (String[] args){
		String file = "/credentials";
		File_IO test = new File_IO();
		test.readFileStream(file);
		test.readFileStreamToList(file);
	}
}
