package ie.ucd.sixth.core.cyber.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FileFinder {
	private static final Logger log = Logger.getLogger(FileFinder.class.getName());

	static {
		log.setLevel(Level.WARNING);
	}

	private Bundle bundle;

	public FileFinder(BundleContext context){
		this.bundle = context.getBundle();
	}

	public ArrayList<URL> findFilesWithExtension(String extension){
		ArrayList<URL> urlList =  new ArrayList<URL>();
		extension = "*."+extension;
		log.info("finding file with extension: " +extension);
		Enumeration e = bundle.findEntries("/", extension, true);
		if(e.hasMoreElements()){
			urlList.add( (URL) e.nextElement());
		}
		return urlList;
	}
}
