package ie.ucd.sixth.core.cyber.utils;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateTime{

	private Calendar calendar;
	private int year;
	private int month;
	private int day;
	private int hour;
	private int minute;
	private int second;
	private boolean timeSet = false;

	public DateTime(){

	}


	public void setCurrentTime(){
		calendar = new GregorianCalendar();

		this.year = calendar.get(Calendar.YEAR);
		this.month = calendar.get(Calendar.MONTH);
		this.day = calendar.get(Calendar.DATE);


		this.hour = calendar.get(Calendar.HOUR_OF_DAY);
		this.minute = calendar.get(Calendar.MINUTE);
		this.second = calendar.get(Calendar.SECOND);
		this.timeSet = true;
	}

	public void setTime(int year, int month, int day, int hour, int minute, int second){
		this.year = year;
		this.month = month;
		this.day = day;
		this.hour = hour;
		this.minute = minute;
		this.second = second;
		this.timeSet = true;
	}
	
	public long differenceInMiliseconds(DateTime time){
		
		if(timeSet){
			long thisMilis = calendar.getTimeInMillis();
			long timeMilis = time.getCalendar().getTimeInMillis();
			return thisMilis - timeMilis;
			
		}else{
			setCurrentTime();
			return differenceInMiliseconds(time);
		}
		
	}
	
	public long differenceInSeconds(DateTime time){
		return (differenceInMiliseconds(time) /1000);
	}

	public float differenceInMinutes(DateTime time){
		return (differenceInMiliseconds(time) /(60*1000));
	}

	public float differenceInHours(DateTime time){
		return (differenceInMiliseconds(time)/(60*60*1000));
	}
	
	public float differenceInDays(DateTime time){
		return (differenceInMiliseconds(time) /(24*60*60*1000));
	}
	
	public float differenceInWeeks(DateTime time){
		return (differenceInMiliseconds(time) / (7*24*60*60*1000));
	}
	
	/*
	 * compare the year for this time to the time provided
	 * if the time has not been set for this time, the current time will be set and compared
	 */
	public int CompareYear(DateTime time){
		if(timeSet){
			return time.getYearInt() - this.year;
		}else{
			setCurrentTime();
			return CompareYear(time);
		}
	}

	/*
	 * compare the month for this time to the time provided
	 * if the time has not been set for this time, the current time will be set and compared
	 */
	public int CompareMonth(DateTime time){
		if(timeSet){
			return time.getMonthInt() - this.month;

		}else{
			setCurrentTime();
			return CompareMonth(time);
		}
	}

	/*
	 * compare the day for this time to the time provided
	 * if the time has not been set for this time, the current time will be set and compared
	 */
	public int CompareDay(DateTime time){
		if(timeSet){
			return time.getDayInt() - this.day;

		}else{
			setCurrentTime();
			return CompareDay(time);
		}
	}

	/*
	 * compare the hours for this time to the time provided
	 * if the time has not been set for this time, the current time will be set and compared
	 */
	public int CompareHour(DateTime time){
		if(timeSet){
			return time.getHourInt() - this.hour;

		}else{
			setCurrentTime();
			return CompareHour(time);
		}
	}

	/*
	 * compare the minutes for this time to the time provided
	 * if the time has not been set for this time, the current time will be set and compared
	 */
	public int CompareMinute(DateTime time){
		if(timeSet){
			return time.getMinuteInt() - this.minute;

		}else{
			setCurrentTime();
			return CompareMinute(time);
		}
	}

	/*
	 * compare the seconds for this time to the time provided
	 * if the time has not been set for this time, the current time will be set and compared
	 */
	public int CompareSecond(DateTime time){
		if(timeSet){
			return time.getSecondInt() - this.second;

		}else{
			setCurrentTime();
			return CompareSecond(time);
		}
	}


	public int getYearInt() {
		return year;
	}

	public String getYearString(){
		return Integer.toString(year);
	}


	public int getMonthInt() {
		return month;
	}

	public String getMonthString() {
		return Integer.toString(month);
	}

	public int getDayInt() {
		return day;
	}

	public String getDayString() {
		return Integer.toString(day);
	}

	public int getHourInt() {
		return hour;
	}

	public String getHourString() {
		return Integer.toString(hour);
	}


	public int getMinuteInt() {
		return minute;
	}

	public String getMinuteString() {
		return Integer.toString(minute);
	}

	public int getSecondInt() {
		return second;
	}

	public String getSecondString() {
		return Integer.toString(second);
	}
	
	public Calendar getCalendar(){
		return calendar;
	}

	/*
	 * just for local testing
	 */
	public static void main(String[] args){
		DateTime test = new DateTime();
		test.setCurrentTime();
	}


	public String getCurrentTime() {
		calendar = new GregorianCalendar();
		String timestamp = "";
		timestamp += calendar.get(Calendar.YEAR)+":";
		timestamp += calendar.get(Calendar.MONTH)+":";
		timestamp += calendar.get(Calendar.DATE)+":";
		timestamp += calendar.get(Calendar.HOUR_OF_DAY)+":";
		timestamp += calendar.get(Calendar.MINUTE)+":";
		timestamp += calendar.get(Calendar.SECOND);
		return timestamp;
	}
	
	public DateTime getTimeObjectFromString(String colonSeparatedDateTime){
		DateTime dt = new DateTime();
		String[] timeArray = colonSeparatedDateTime.split(":");
		if(timeArray!=null && timeArray.length == 6){ //correct format
			this.year = Integer.parseInt(timeArray[0]);
			this.month = Integer.parseInt(timeArray[1]);
			this.day = Integer.parseInt(timeArray[2]);
			this.hour = Integer.parseInt(timeArray[3]);
			this.minute = Integer.parseInt(timeArray[4]);
			this.second = Integer.parseInt(timeArray[5]);
		}
		return dt;
	}
}
