package ie.ucd.sixth.core.cyber.utils;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * utility for reading in  credentials which must be in the format:
 * 
 * 
 * propertyName=propertyvalue
 * 
 * E.g: Twitter credentials look like:
 * 
 * oauth.consumerKey=********************
 * oauth.consumerSecret=***********************
 * oauth.accessToken=****************************
 * oauth.accessTokeSecret=*************************
 * oauth.authenticatedUserName=*****************
 */
public class CredentialsReader{
	
	File_IO fileManager;
	
	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
	
	public CredentialsReader(){
		fileManager = new File_IO();
	}
	
	public HashMap<String, String> readFile(String filePath){
		HashMap<String, String> credentialsMap = new HashMap<String, String>();
		ArrayList<String> fileList = fileManager.readFileStreamToList(filePath);
		for (String string : fileList) {
			logger.info("fileList element:  "+string);
			String[] lineString = string.split("=");

			//if the credentials are not in the correct format return null
			if(lineString.length!=2){
				logger.severe("authentication credentials were not provided correctly");
				return null;
			}
			
			credentialsMap.put(lineString[0], lineString[1]);
			
			
		}
		return credentialsMap;
	}

	
}
