package ie.ucd.sixth.core.cyber.utils;

import java.util.HashMap;

public class Credentials {

	private String sensorType;
	private HashMap<String, String> credentialsMap;
	private boolean rateLimited = false;
	private DateTime currentTime;
	private DateTime rateLimitedTime;
	
	private int maxCallsPerHour;
	private int callsMadeThishour;
	private DateTime resetTime;
	
	private int numCreds = 0;
	
	

	public Credentials(String sensorType, boolean rateLimited){
		currentTime = new DateTime();
		rateLimitedTime = new DateTime();
		this.rateLimited = rateLimited;
		credentialsMap = new HashMap<String, String>();
		this.sensorType = sensorType;
	}
	
	
	public HashMap<String, String> getCredentials(){
		return credentialsMap;
	}
	
	public void setCredentials(HashMap<String, String> credentials){
		credentialsMap = credentials;
	}
	
	public void addCredential(String key, String value){
		
		credentialsMap.put(key, value);
		numCreds++;
	}
	
	public void setSensorType(String sensorType){
		this.sensorType = sensorType;
	}
	
	public String getSensorType(){
		return this.sensorType;
	}
	
	public void markRateLimited(){
		this.rateLimited = true;
		this.rateLimitedTime.setCurrentTime();
	}
	
	
	public void checkDurationRateLimited(){
		currentTime.setCurrentTime(); //set the time to now
		
	}
	
	public void setMaxCallsPerHour(int maxCallsPerhour){
		this.maxCallsPerHour = maxCallsPerhour;
	}
	
	public void setCallsMadeThisHour(int callsMadeThisHour){
		this.callsMadeThishour = callsMadeThisHour;
	}
	
	public void setResetTime(DateTime resetTime){
		this.resetTime = resetTime;
	}
	
	public int getNumCreds(){
		return numCreds;
	}
}
