package ie.ucd.sixth.core.cyber.sensor;

import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SIXTH;
import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractCyberAdaptor;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IRetaskingService;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IPipeService;

import java.util.Map;

public class NetworkAbstraction {

	private static final String locationInvariant = "locationname";
	private static final String entityInvariant = "keyword";
	private static final String userInvariant = "user";
	/**
	 * boolean properties
	 */
	public static final String GENERATE_USERS_PROPERTY = "generateusersensors";
	public static final String GENERATE_ENTITIES_PROPERTY = "generateentitysensors";
	public static final String GENERATE_LOCATIONS_PROPERTY = "generatelocationsensors";
	public static final String STATE_PROPERTY = "state";

	private boolean generateUsers = false;
	private boolean generateEntities = false;
	private boolean generateLocations = false;
	private boolean state = false;

	/**
	 * String properties
	 */
	public static final String INVARIANT_PROPERTY = "invariant";
	public static final String PIPE_FOR_USER = "userpipe";
	public static final String PIPE_FOR_ENTITY = "entitypipe";
	public static final String PIPE_FOR_LOCATION = "locationpipe";
	public static final String PIPE_FOR_BASESENSOR = "pipe";

	private String invariant = "";
	private String userPipes = "";
	private String entityPipes = "";
	private String locationPipes = "";
	private AbstractCyberAdaptor adaptor;
	private CyberSensor baseSensor;
	private int abstractionID;
	private String networkType;

	private boolean coords = false;
	private String baseSensorPipes = "";
	public NetworkAbstraction(AbstractCyberAdaptor adaptor, CyberSensor baseSensor){
		this.adaptor = adaptor;
		this.baseSensor = baseSensor;
		this.abstractionID = baseSensor.getID();
		this.networkType = adaptor.getInfo().getName();

	}


	public void setProperty(String propertyName, String value){
		if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_USERS_PROPERTY) && value.equalsIgnoreCase("on")){
			generateUsers = true;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_USERS_PROPERTY) && value.equalsIgnoreCase("off")){
			generateUsers = false;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_ENTITIES_PROPERTY) && value.equalsIgnoreCase("on")){
			generateEntities = true;
		}	
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_ENTITIES_PROPERTY) && value.equalsIgnoreCase("off")){
			generateEntities = false;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_LOCATIONS_PROPERTY) && value.equalsIgnoreCase("on")){
			generateLocations = true;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_LOCATIONS_PROPERTY) && value.equalsIgnoreCase("off")){
			generateLocations = false;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+STATE_PROPERTY) && value.equalsIgnoreCase("on")){
			this.state = true;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+STATE_PROPERTY) && value.equalsIgnoreCase("off")){
			this.state = false;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+INVARIANT_PROPERTY) && !value.isEmpty()){
			invariant = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_USER) && !value.isEmpty()){
			userPipes = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_LOCATION) && !value.isEmpty()){
			locationPipes = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_ENTITY) && !value.isEmpty()){
			entityPipes = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_BASESENSOR) && !value.isEmpty()){
			baseSensorPipes = value;
		}

	}

	public void startNetwork(){
		if(state){
			String pipeline = ""; //the pipeline to apply to the base sensor
			Map<String, IPipeAdaptor> pipes = adaptor.getPipeMap();
			if(!baseSensorPipes.isEmpty()){
				String[] basePipesArr = baseSensorPipes.split(".");
				if(basePipesArr.length==3){
					String pipeAdaptorName = basePipesArr[0];
					String pipeType = basePipesArr[1];
					String serviceName = basePipesArr[2];
					if(pipes.containsKey(pipeAdaptorName)){
						AbstractPipeAdaptor basePipeAdaptor = (AbstractPipeAdaptor) pipes.get(pipeAdaptorName);
//						System.out.println("have pipe adaptor: " +(basePipeAdaptor==null));
						IPipeService basePipe = basePipeAdaptor.createIPipe(serviceName);
						pipeline = basePipe.getID()+";";
					}
				}
			}


			if(pipes.containsKey("basic")){ //this has the sensor creator pipe
				AbstractPipeAdaptor basicPipeAdaptor = (AbstractPipeAdaptor) pipes.get("basic");
//				System.out.println("have basic pipe adaptor: " +(basicPipeAdaptor==null));
				if(generateLocations){
					IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("locationsensorcreator");
					pipeline += sensorCreatorPipe.getID()+";";
					sensorCreatorPipe.setProperty("sensorType", "location");
					sensorCreatorPipe.setProperty("networktype", networkType);
					if(!locationPipes.isEmpty()){

						String[] locPipesArr = locationPipes.split(".");
						if(locPipesArr.length==3){
							String locpipeAdaptorName = locPipesArr[0];
							String locpipeType = locPipesArr[1];
							String locserviceName = locPipesArr[2];
							if(pipes.containsKey(locpipeAdaptorName)){
								AbstractPipeAdaptor locPipeAdaptor = (AbstractPipeAdaptor) pipes.get(locpipeAdaptorName);
//								System.out.println("have locpipe adaptor: " +(locPipeAdaptor==null));
								IPipeService locPipe = locPipeAdaptor.createIPipe(locserviceName);
								sensorCreatorPipe.setProperty("pipe", locPipe.getID()+"");
							}
						}
					}

				}
				if(generateEntities){
					IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("entitysensorcreator");
					pipeline+=sensorCreatorPipe.getID()+";";
					sensorCreatorPipe.setProperty("sensorType", "entity");
					sensorCreatorPipe.setProperty("networktype", networkType);
					if(!entityPipes.isEmpty()){
						String[] entPipesArr = entityPipes.split(".");
						if(entPipesArr.length==3){
							String entpipeAdaptorName = entPipesArr[0];
							String entpipeType = entPipesArr[1];
							String entserviceName = entPipesArr[2];
							if(pipes.containsKey(entpipeAdaptorName)){
								AbstractPipeAdaptor entPipeAdaptor = (AbstractPipeAdaptor) pipes.get(entpipeAdaptorName);
//								System.out.println("have entpipe adaptor: " +(entPipeAdaptor==null));
								IPipeService entPipe = entPipeAdaptor.createIPipe(entserviceName);
								sensorCreatorPipe.setProperty("pipe", entPipe.getID()+"");
							}
						}
					}
				}
				if(generateUsers){
					IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("usersensorcreator");
					pipeline+=sensorCreatorPipe.getID()+";";
					sensorCreatorPipe.setProperty("sensorType", "user");
					sensorCreatorPipe.setProperty("networktype", networkType);
					if(!userPipes.isEmpty()){
						String[] userPipesArr = userPipes.split("\\.");
						if(userPipesArr.length==3){
							String userpipeAdaptorName = userPipesArr[0];
							String userpipeType = userPipesArr[1];
							String userserviceName = userPipesArr[2];
//							System.out.println("user pipe adaptor name: " +userpipeAdaptorName);

							if(pipes.containsKey(userpipeAdaptorName)){
								AbstractPipeAdaptor userPipeAdaptor = (AbstractPipeAdaptor) pipes.get(userpipeAdaptorName);
//								System.out.println("have userpipe adaptor: " +(userPipeAdaptor==null));
								IPipeService userPipe = userPipeAdaptor.createIPipe(userserviceName);
								sensorCreatorPipe.setProperty("pipe", userPipe.getID()+"");
							}
						}					
					}
				}
			}


			if(pipeline.endsWith(";")){
				pipeline = pipeline.substring(0, pipeline.length()-1);
			}

			//last thing to do is task the base sensor with the pipeline
			taskBaseSensor(pipeline);



		}
	}


	private void taskBaseSensor(String pipeline) {
//		System.out.println("about to task base sensor: " +pipeline);
		String invariantProperty = "";
		if(baseSensor.getSensorType().equalsIgnoreCase(EntityCyberSensor.TYPE)){
			invariantProperty =  "<property name=\'keyword\'>"+invariant+"</property>";

		}
		else if(baseSensor.getSensorType().equalsIgnoreCase(LocationCyberSensor.TYPE)){
			if(!invariant.contains(",")){
				invariantProperty =  "<property name=\'locationname\'>"+invariant+"</property>";
				coords=false;
			}else{
				String[] inv = invariant.split(",");
				if(inv.length==2){
					try{
						Double.parseDouble(inv[0]);
						Double.parseDouble(inv[1]);
						invariantProperty =  "<property name=\'latlong\'>"+invariant+"</property>";
						coords = true;
					}catch(NumberFormatException e){}
				}
			}
		}
		else if(baseSensor.getSensorType().equalsIgnoreCase(UserCyberSensor.TYPE)){
			invariantProperty =  "<property name=\'userid\'>"+invariant+"</property>";

		}
		String xmlString = "<configureSensor>"
				+ "<sensor type=\'"+networkType+"."+baseSensor.getSensorType()+"\' id=\'"+baseSensor.getID()+"\'>"
				+ invariantProperty
				+ "<property name=\'frequency\'>1</property>"
				+ "<property name=\'networkid\'>"+abstractionID+"</property>"
				+ "<property name=\'pipe\'>"+pipeline+"</property>"
				+ "<property name=\'state\'>on</property>"
				+"</sensor></configureSensor>";
		IDiscovery discovery = SIXTH.getDiscoveryHandler().getDiscovery(SIXTH.PASS);
		IRetaskingService retaskingService = discovery.getRetaskingService();
		RetaskingMsg msg = RetaskingMsg.retask(xmlString);
		// so we know what adaptor this is intended for
		msg.setAdaptor(adaptor.getInfo());
		boolean success = retaskingService.retask(msg);
	}


}
