package ie.ucd.sixth.core.cyber.sensor;

import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SIXTH;
import ie.ucd.sixth.core.adaptor.IAdaptor;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractCyberAdaptor;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IRetaskingService;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IPipeService;

import java.util.Map;

/**
 * An infrastructure abstraction if grounded by a single adaptor/sensor type
 * Additional base sensors can be added in the configuration message from the application (TODO: Future work)
 * 
 * When the infrastructure is started, the sensor(s) are tasked with pipelines according to the sensor generation rules
 * 
 * Advanced rules are configured in the sensor creator pipes which add additional pipelines to generated sensors for the network to grow further at runtime
 * @author olgamurdoch1_old_iMac
 *
 */
public class InfrastructureAbstraction {

	private static final String locationInvariant = "locationname";
	private static final String entityInvariant = "keyword";
	private static final String userInvariant = "user";
	/**
	 * basic sensor production properties for generating sensors based on data from base sensor 
	 * (value = 'all' for creating sensor type from all adaptors or 'adaptorname' for creating sensor types from a specific adaptor type
	 */ 
	public static final String GENERATE_USERS_PROPERTY = "generateusersensors"; 
	public static final String GENERATE_ENTITIES_PROPERTY = "generateentitysensors";
	public static final String GENERATE_LOCATIONS_PROPERTY = "generatelocationsensors";
	public static final String STATE_PROPERTY = "state";

	/**
	 * advanced sensor production properties for generating sensors based on generated sensor
	 */
	public static final String GENERATE_USERS_FROM_ENTITIES_PROPERTY = "generateusersfromentities";
	public static final String GENERATE_USERS_FROM_LOCATIONS_PROPERTY = "generateusersfromlocations";
	public static final String GENERATE_USERS_FROM_USERS_PROPERTY = "generateusersfromusers";

	public static final String GENERATE_ENTITIES_FROM_ENTITIES_PROPERTY = "generateentitiesfromentities";
	public static final String GENERATE_ENTITIES_FROM_LOCATIONS_PROPERTY = "generateentitiesfromlocations";
	public static final String GENERATE_ENTITIES_FROM_USERS_PROPERTY = "generateentitiesfromusers";

	public static final String GENERATE_LOCATIONS_FROM_ENTITIES_PROPERTY = "generatelocationsfromentities";
	public static final String GENERATE_LOCATIONS_FROM_LOCATIONS_PROPERTY = "generatelocationsfromlocations";
	public static final String GENERATE_LOCATIONS_FROM_USERS_PROPERTY = "generatelocationsfromusers";

//	public static final String CONSTRAIN_LOCATION_SENSORS_TO_ADAPTOR = "constrainlocationsensors";
//	public static final String CONSTRAIN_ENTITY_SENSORS_TO_ADAPTOR = "constrainentitysensors";
//	public static final String CONSTRAIN_USER_SENSORS_TO_ADAPTOR = "constrainusersensors";
	
	public static final String PIPE_FOR_USER = "userpipe";
	public static final String PIPE_FOR_ENTITY = "entitypipe";
	public static final String PIPE_FOR_LOCATION = "locationpipe";
	public static final String PIPE_FOR_BASESENSOR = "pipe";
	
	private String userPipes = "";
	private String entityPipes = "";
	private String locationPipes = "";
	private String baseSensorPipes = "";



	//advanced sensor generation rules
	private String generateUsersFromEntitiesAdaptorType = "";
	private String generateUsersFromLocationsAdaptorType = "";
	private String generateUsersFromUsersAdaptorType = "";
	private String generateEntitiesFromEntitiesAdaptorType = "";
	private String generateEntitiesFromLocationsAdaptorType = "";
	private String generateEntitiesFromUsersAdaptorType = "";
	private String generateLocationsFromEntitiesAdaptorType = "";
	private String generateLocationsFromLocationsAdaptorType = "";
	private String generateLocationsFromUsersAdaptorType = "";

	private String generateUsersFromAdaptorType="";
	private String generateEntitiesFromAdaptorType="";
	private String generateLocationsFromAdaptorType = "";
	private boolean state = false;

	/**
	 * String properties
	 */
	public static final String INVARIANT_PROPERTY = "invariant";
	private String invariant = "";

	private AbstractCyberAdaptor adaptor;
	private CyberSensor baseSensor;
	private int abstractionID;
	private String networkType;

	private boolean coords = false;

	/**
	 * create a new infrastructure abstraction that is grounded by a single adaptor/sensor type
	 * @param adaptor
	 * @param baseSensor
	 */
	public InfrastructureAbstraction(AbstractCyberAdaptor adaptor, CyberSensor baseSensor){
		this.adaptor = adaptor;
		this.baseSensor = baseSensor;
		this.abstractionID = baseSensor.getID();
		this.networkType = adaptor.getInfo().getName();

	}



	public void setProperty(String propertyName, String value){
		if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_USERS_PROPERTY) && !value.isEmpty()){
			generateUsersFromAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_ENTITIES_PROPERTY) && !value.isEmpty()){
			generateEntitiesFromAdaptorType = value;
		}	
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_LOCATIONS_PROPERTY) && !value.isEmpty()){
			generateLocationsFromAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+STATE_PROPERTY) && value.equalsIgnoreCase("on")){
			this.state = true;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+STATE_PROPERTY) && value.equalsIgnoreCase("off")){
			this.state = false;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+INVARIANT_PROPERTY) && !value.isEmpty()){
			invariant = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_USERS_FROM_USERS_PROPERTY) && !value.isEmpty()){
			this.generateUsersFromUsersAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_USERS_FROM_ENTITIES_PROPERTY) && !value.isEmpty()){	
			this.generateUsersFromEntitiesAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_USERS_FROM_LOCATIONS_PROPERTY) && !value.isEmpty()){
			this.generateUsersFromLocationsAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_ENTITIES_FROM_USERS_PROPERTY) && !value.isEmpty()){
			this.generateEntitiesFromUsersAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_ENTITIES_FROM_ENTITIES_PROPERTY) && !value.isEmpty()){
			this.generateEntitiesFromEntitiesAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_ENTITIES_FROM_LOCATIONS_PROPERTY) && !value.isEmpty()){
			this.generateEntitiesFromLocationsAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_LOCATIONS_FROM_USERS_PROPERTY) && !value.isEmpty()){
			this.generateLocationsFromUsersAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_LOCATIONS_FROM_ENTITIES_PROPERTY) && !value.isEmpty()){
			this.generateLocationsFromEntitiesAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+GENERATE_LOCATIONS_FROM_LOCATIONS_PROPERTY) && !value.isEmpty()){
			this.generateLocationsFromLocationsAdaptorType = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_USER) && !value.isEmpty()){
			userPipes = value;
			
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_LOCATION) && !value.isEmpty()){
			locationPipes = value;
			
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_ENTITY) && !value.isEmpty()){
			entityPipes = value;
		}
		else if(propertyName.equalsIgnoreCase(networkType+"."+PIPE_FOR_BASESENSOR) && !value.isEmpty()){
			baseSensorPipes = value;
		}

	}
	
	
	/**
	 * The base sensor has already been created. 
	 * To start the infrastructure we need to add a pipeline to the base sensor that implements the sensor production rules configured by the user
	 * The sensor production rules all sensors of any type and from any adaptor to be generated recursively from the base sensor
	 */
	public void startInfrastructure(){
		if(state){
			String pipeline = "";
		
			if(!baseSensorPipes.isEmpty()){
				Map<String, IPipeAdaptor> pipes = adaptor.getPipeMap();

				String[] basePipesArr = baseSensorPipes.split("\\.");
				if(basePipesArr.length==3){
					String pipeAdaptorName = basePipesArr[0];
					String pipeType = basePipesArr[1];
					String serviceName = basePipesArr[2];
					if(pipes.containsKey(pipeAdaptorName)){
						AbstractPipeAdaptor basePipeAdaptor = (AbstractPipeAdaptor) pipes.get(pipeAdaptorName);
//						System.out.println("have pipe adaptor: " +(basePipeAdaptor==null));
						IPipeService basePipe = basePipeAdaptor.createIPipe(serviceName);
						pipeline = basePipe.getID()+";";
					}
				}
			}
				// the rule to create location sensors from a specific adaptor, based on the base sensor is set
				if(generateLocationsFromAdaptorType!=null && !generateLocationsFromAdaptorType.isEmpty()){
					pipeline+=createLocationCreationPipeLine(generateLocationsFromAdaptorType); //will check advanced settings and configure pipe accordingly
				
				}
				// the rule to create entity sensors from a specific adaptor, based on the base sensor is set
				if(generateEntitiesFromAdaptorType!=null && !generateEntitiesFromAdaptorType.isEmpty()){
					pipeline+=createEntityCreationPipeLine(generateEntitiesFromAdaptorType); //will check advanced settings and configure pipe accordingly
					
				}
				// the rule to create user sensors from a specific adaptor, based on the base sensor is set
				if(generateUsersFromAdaptorType!=null && !generateUsersFromAdaptorType.isEmpty()){
					pipeline+=createUserCreationPipeLine(generateUsersFromAdaptorType); //will check advanced settings and configure pipe accordingly
					
				}
			

			if(pipeline.startsWith(";")){
				pipeline = pipeline.substring(1, pipeline.length());
			}
			if(pipeline.endsWith(";")){
				pipeline = pipeline.substring(0,pipeline.length()-1);
			}
			//last thing to do is task the base sensor with the pipeline
			taskBaseSensor(pipeline);
		}
	}

	private void taskBaseSensor(String pipeline) {
		String invariantProperty = "";
		if(baseSensor.getSensorType().equalsIgnoreCase(EntityCyberSensor.TYPE)){
			invariantProperty =  "<property name=\'keyword\'>"+invariant+"</property>";

		}
		else if(baseSensor.getSensorType().equalsIgnoreCase(LocationCyberSensor.TYPE)){
			if(!invariant.contains(",")){
				invariantProperty =  "<property name=\'locationname\'>"+invariant+"</property>";
				coords=false;
			}else{
				String[] inv = invariant.split(",");
				if(inv.length==2){
					try{
						Double.parseDouble(inv[0]);
						Double.parseDouble(inv[1]);
						invariantProperty =  "<property name=\'latlong\'>"+invariant+"</property>";
						coords = true;
					}catch(NumberFormatException e){}
				}
			}
		}
		else if(baseSensor.getSensorType().equalsIgnoreCase(UserCyberSensor.TYPE)){
			invariantProperty =  "<property name=\'userid\'>"+invariant+"</property>";

		}
		String xmlString = "<configureSensor>"
				+ "<sensor type=\'"+networkType+"."+baseSensor.getSensorType()+"\' id=\'"+baseSensor.getID()+"\'>"
				+ invariantProperty
				+ "<property name=\'frequency\'>1</property>"
				+ "<property name=\'infrastructureid\'>"+abstractionID+"</property>"
				+ "<property name=\'pipe\'>"+pipeline+"</property>"
				+ "<property name=\'state\'>on</property>"
				+"</sensor></configureSensor>";
		IDiscovery discovery = SIXTH.getDiscoveryHandler().getDiscovery(SIXTH.PASS);
		IRetaskingService retaskingService = discovery.getRetaskingService();
		RetaskingMsg msg = RetaskingMsg.retask(xmlString);
		// so we know what adaptor this is intended for
		msg.setAdaptor(adaptor.getInfo());
		boolean success = retaskingService.retask(msg);
	}
	
	private String createEntityCreationPipeLine(String rule){
		String pipeline = "";
		Map<String, IPipeAdaptor> pipes = adaptor.getPipeMap(); //so we can find out what pipes are available
		Map<String, ISensorAdaptor> sensors = adaptor.getSensorAdaptorMap(); //so we can find out what sensors are available
		if(pipes.containsKey("basic")){ //this has the sensor creator pipe
			AbstractPipeAdaptor basicPipeAdaptor = (AbstractPipeAdaptor) pipes.get("basic");
//			System.out.println("have basic pipe adaptor: " +(basicPipeAdaptor==null));
 
			if(rule.equalsIgnoreCase("all")){ //the adaptor type has not been specified so we look for location sensors from all adaptors

				for (String adaptorName : sensors.keySet()) {
					IAdaptor ad = sensors.get(adaptorName);
					if(ad.getSpecification().contains("entity")){
						IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("entitysensorcreator");
						pipeline += sensorCreatorPipe.getID()+";";
						sensorCreatorPipe.setProperty("sensorType", "entity");
						sensorCreatorPipe.setProperty("networktype", adaptorName);


						//check for advanced rules for generating sensors types based on generated entity sensors so that the creator pipe applies additional creator pipes to the new sensors accordingly
						
						
						//check if the rule has been set to generate users from generated entity sensors 
						if(generateUsersFromEntitiesAdaptorType!=null && !generateUsersFromEntitiesAdaptorType.isEmpty()){
							if(generateUsersFromEntitiesAdaptorType.equalsIgnoreCase("all")){ //all adaptors are required
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("user")){//if the adaptor type supports user sensors
										sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_ENTITIES_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateUsersFromEntitiesAdaptorType)){ //just use the specified adaptor type
								sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_ENTITIES_PROPERTY, generateUsersFromEntitiesAdaptorType);
							}

						}

						//if the rule has been set to generate entities from generated entity sensors
						if(generateEntitiesFromEntitiesAdaptorType!=null && !generateEntitiesFromEntitiesAdaptorType.isEmpty()){
							if(generateEntitiesFromEntitiesAdaptorType.equalsIgnoreCase("all")){
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("entity")){//if the adaptor type supports entity sensors
										sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_ENTITIES_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateEntitiesFromEntitiesAdaptorType)){
								sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_ENTITIES_PROPERTY, generateEntitiesFromEntitiesAdaptorType);

							}
						}

						//if the rule has been set to generate locations from generated entity sensors
						if(generateLocationsFromEntitiesAdaptorType!=null && !generateLocationsFromEntitiesAdaptorType.isEmpty()){
							if(generateLocationsFromEntitiesAdaptorType.equalsIgnoreCase("all")){
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("location")){//if the adaptor type supports location sensors
										sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_ENTITIES_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateLocationsFromEntitiesAdaptorType)){
								sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_ENTITIES_PROPERTY, generateLocationsFromEntitiesAdaptorType);
							}
						

						}
						
						if(!entityPipes.isEmpty()){
							String[] entPipesArr = entityPipes.split("\\.");
							if(entPipesArr.length==3){
								String entpipeAdaptorName = entPipesArr[0];
								String entpipeType = entPipesArr[1];
								String entserviceName = entPipesArr[2];
								if(pipes.containsKey(entpipeAdaptorName)){
									AbstractPipeAdaptor entPipeAdaptor = (AbstractPipeAdaptor) pipes.get(entpipeAdaptorName);
//									System.out.println("have entpipe adaptor: " +(entPipeAdaptor==null));
									IPipeService entPipe = entPipeAdaptor.createIPipe(entserviceName);
									sensorCreatorPipe.setProperty("pipe", entPipe.getID()+"");
								}
							}
						}
					}
					
					
				}


			}else if(sensors.containsKey(rule)){ //the adaptor type has been specified
				IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("entitysensorcreator");
				pipeline += sensorCreatorPipe.getID()+";";
				sensorCreatorPipe.setProperty("sensorType", "entity");
				sensorCreatorPipe.setProperty("networktype", rule);
				//check for advanced rules for generating sensors types based on generated entity sensors so that the creator pipe applies additional creator pipes to the new sensors accordingly
				
				
				//check if the rule has been set to generate users from generated entity sensors 
				if(generateUsersFromEntitiesAdaptorType!=null && !generateUsersFromEntitiesAdaptorType.isEmpty()){
					if(generateUsersFromEntitiesAdaptorType.equalsIgnoreCase("all")){ //all adaptors are required
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("user")){//if the adaptor type supports user sensors
								sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_ENTITIES_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateUsersFromEntitiesAdaptorType)){ //just use the specified adaptor type
						sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_ENTITIES_PROPERTY, generateUsersFromEntitiesAdaptorType);
					}

				}

				//if the rule has been set to generate entities from generated entity sensors
				if(generateEntitiesFromEntitiesAdaptorType!=null && !generateEntitiesFromEntitiesAdaptorType.isEmpty()){
					if(generateEntitiesFromEntitiesAdaptorType.equalsIgnoreCase("all")){
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("entity")){//if the adaptor type supports entity sensors
								sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_ENTITIES_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateEntitiesFromEntitiesAdaptorType)){
						sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_ENTITIES_PROPERTY, generateEntitiesFromEntitiesAdaptorType);

					}
				}

				//if the rule has been set to generate locations from generated entity sensors
				if(generateLocationsFromEntitiesAdaptorType!=null && !generateLocationsFromEntitiesAdaptorType.isEmpty()){
					if(generateLocationsFromLocationsAdaptorType.equalsIgnoreCase("all")){
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("location")){//if the adaptor type supports location sensors
								sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_ENTITIES_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateLocationsFromEntitiesAdaptorType)){
						sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_ENTITIES_PROPERTY, generateLocationsFromEntitiesAdaptorType);
					}
				

				}
				
				if(!entityPipes.isEmpty()){
					String[] entPipesArr = entityPipes.split("\\.");
					if(entPipesArr.length==3){
						String entpipeAdaptorName = entPipesArr[0];
						String entpipeType = entPipesArr[1];
						String entserviceName = entPipesArr[2];
						if(pipes.containsKey(entpipeAdaptorName)){
							AbstractPipeAdaptor entPipeAdaptor = (AbstractPipeAdaptor) pipes.get(entpipeAdaptorName);
//							System.out.println("have entpipe adaptor: " +(entPipeAdaptor==null));
							IPipeService entPipe = entPipeAdaptor.createIPipe(entserviceName);
							sensorCreatorPipe.setProperty("pipe", entPipe.getID()+"");
						}
					}
				}
			
			}
		}
		return pipeline;
	}
	
	private String createLocationCreationPipeLine(String rule){
		String pipeline = "";
		Map<String, IPipeAdaptor> pipes = adaptor.getPipeMap(); //so we can find out what pipes are available
		Map<String, ISensorAdaptor> sensors = adaptor.getSensorAdaptorMap(); //so we can find out what sensors are available
		if(pipes.containsKey("basic")){ //this has the sensor creator pipe
			AbstractPipeAdaptor basicPipeAdaptor = (AbstractPipeAdaptor) pipes.get("basic");
//			System.out.println("have basic pipe adaptor: " +(basicPipeAdaptor==null));
 
			if(rule.equalsIgnoreCase("all")){ //the adaptor type has not been specified so we look for location sensors from all adaptors

				for (String adaptorName : sensors.keySet()) {
					IAdaptor ad = sensors.get(adaptorName);
					if(ad.getSpecification().contains("location")){
						IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("locationsensorcreator");
						pipeline += sensorCreatorPipe.getID()+";";
						sensorCreatorPipe.setProperty("sensorType", "location");
						sensorCreatorPipe.setProperty("networktype", adaptorName);


						//check for advanced rules for generating sensors types based on generated location sensors so that the creator pipe applies additional creator pipes to the new sensors accordingly
						
						
						//check if the rule has been set to generate users from generated location sensors 
						if(generateUsersFromLocationsAdaptorType!=null && !generateUsersFromLocationsAdaptorType.isEmpty()){
							if(generateUsersFromLocationsAdaptorType.equalsIgnoreCase("all")){ //all adaptors are required
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("user")){//if the adaptor type supports user sensors
										sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_LOCATIONS_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateUsersFromLocationsAdaptorType)){ //just use the specified adaptor type
								sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_LOCATIONS_PROPERTY, generateUsersFromLocationsAdaptorType);
							}
							
							if(!userPipes.isEmpty()){

								String[] userPipesArr = userPipes.split("\\.");
								if(userPipesArr.length==3){
									String userpipeAdaptorName = userPipesArr[0];
									String userpipeType = userPipesArr[1];
									String userserviceName = userPipesArr[2];
									if(pipes.containsKey(userpipeAdaptorName)){
										AbstractPipeAdaptor userPipeAdaptor = (AbstractPipeAdaptor) pipes.get(userpipeAdaptorName);
										System.out.println("have locpipe adaptor: " +(userPipeAdaptor==null));
										IPipeService userPipe = userPipeAdaptor.createIPipe(userserviceName);
										sensorCreatorPipe.setProperty("pipe", userPipe.getID()+"");
//										System.exit(0);
									}
								}
							}

						}

						//if the rule has been set to generate entities from generated location sensors
						if(generateEntitiesFromLocationsAdaptorType!=null && !generateEntitiesFromLocationsAdaptorType.isEmpty()){
							if(generateEntitiesFromLocationsAdaptorType.equalsIgnoreCase("all")){
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("entity")){//if the adaptor type supports entity sensors
										sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_LOCATIONS_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateEntitiesFromLocationsAdaptorType)){
								sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_LOCATIONS_PROPERTY, generateEntitiesFromLocationsAdaptorType);

							}
						}

						//if the rule has been set to generate locations from generated location sensors
						if(generateLocationsFromLocationsAdaptorType!=null && !generateLocationsFromLocationsAdaptorType.isEmpty()){
							if(generateLocationsFromLocationsAdaptorType.equalsIgnoreCase("all")){
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("location")){//if the adaptor type supports location sensors
										sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_LOCATIONS_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateLocationsFromLocationsAdaptorType)){
								sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_LOCATIONS_PROPERTY, generateLocationsFromLocationsAdaptorType);
							}
						

						}
						
						if(!locationPipes.isEmpty()){

							String[] locPipesArr = locationPipes.split("\\.");
							if(locPipesArr.length==3){
								String locpipeAdaptorName = locPipesArr[0];
								String locpipeType = locPipesArr[1];
								String locserviceName = locPipesArr[2];
								if(pipes.containsKey(locpipeAdaptorName)){
									AbstractPipeAdaptor locPipeAdaptor = (AbstractPipeAdaptor) pipes.get(locpipeAdaptorName);
									System.out.println("have locpipe adaptor: " +(locPipeAdaptor==null));
									IPipeService locPipe = locPipeAdaptor.createIPipe(locserviceName);
									sensorCreatorPipe.setProperty("pipe", locPipe.getID()+"");
								}
							}
						}
					}
				}
				

			}else if(sensors.containsKey(rule)){ //the adaptor type has been specified
				IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("locationsensorcreator");
				pipeline += sensorCreatorPipe.getID()+";";
				sensorCreatorPipe.setProperty("sensorType", "location");
				sensorCreatorPipe.setProperty("networktype", rule);
				//check for advanced rules for generating sensors types based on generated location sensors so that the creator pipe applies additional creator pipes to the new sensors accordingly
				
				
				//check if the rule has been set to generate users from generated location sensors 
				if(generateUsersFromLocationsAdaptorType!=null && !generateUsersFromLocationsAdaptorType.isEmpty()){
					if(generateUsersFromLocationsAdaptorType.equalsIgnoreCase("all")){ //all adaptors are required
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("user")){//if the adaptor type supports user sensors
								sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_LOCATIONS_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateUsersFromLocationsAdaptorType)){ //just use the specified adaptor type
						sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_LOCATIONS_PROPERTY, generateUsersFromLocationsAdaptorType);
					}

				}

				//if the rule has been set to generate entities from generated location sensors
				if(generateEntitiesFromLocationsAdaptorType!=null && !generateEntitiesFromLocationsAdaptorType.isEmpty()){
					if(generateEntitiesFromLocationsAdaptorType.equalsIgnoreCase("all")){
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("entity")){//if the adaptor type supports entity sensors
								sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_LOCATIONS_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateEntitiesFromLocationsAdaptorType)){
						sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_LOCATIONS_PROPERTY, generateEntitiesFromLocationsAdaptorType);

					}
				}

				//if the rule has been set to generate locations from generated location sensors
				if(generateLocationsFromLocationsAdaptorType!=null && !generateLocationsFromLocationsAdaptorType.isEmpty()){
					if(generateLocationsFromLocationsAdaptorType.equalsIgnoreCase("all")){
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("location")){//if the adaptor type supports location sensors
								sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_LOCATIONS_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateLocationsFromLocationsAdaptorType)){
						sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_LOCATIONS_PROPERTY, generateLocationsFromLocationsAdaptorType);
					}
					
					if(!locationPipes.isEmpty()){

						String[] locPipesArr = locationPipes.split("\\.");
						if(locPipesArr.length==3){
							String locpipeAdaptorName = locPipesArr[0];
							String locpipeType = locPipesArr[1];
							String locserviceName = locPipesArr[2];
							if(pipes.containsKey(locpipeAdaptorName)){
								AbstractPipeAdaptor locPipeAdaptor = (AbstractPipeAdaptor) pipes.get(locpipeAdaptorName);
//								System.out.println("have locpipe adaptor: " +(locPipeAdaptor==null));
								IPipeService locPipe = locPipeAdaptor.createIPipe(locserviceName);
								sensorCreatorPipe.setProperty("pipe", locPipe.getID()+"");
							}
						}
					}
				

				}
			
			}
		}
		
		
		return pipeline;
	}
	
	private String createUserCreationPipeLine(String rule){
		String pipeline = "";
		Map<String, IPipeAdaptor> pipes = adaptor.getPipeMap(); //so we can find out what pipes are available
		Map<String, ISensorAdaptor> sensors = adaptor.getSensorAdaptorMap(); //so we can find out what sensors are available
		if(pipes.containsKey("basic")){ //this has the sensor creator pipe
			AbstractPipeAdaptor basicPipeAdaptor = (AbstractPipeAdaptor) pipes.get("basic");
//			System.out.println("have basic pipe adaptor: " +(basicPipeAdaptor==null));
 
			if(rule.equalsIgnoreCase("all")){ //the adaptor type has not been specified so we look for location sensors from all adaptors

				for (String adaptorName : sensors.keySet()) {
					IAdaptor ad = sensors.get(adaptorName);
					if(ad.getSpecification().contains("user")){
						IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("usersensorcreator");
						pipeline += sensorCreatorPipe.getID()+";";
						sensorCreatorPipe.setProperty("sensorType", "user");
						sensorCreatorPipe.setProperty("networktype", adaptorName);


						//check for advanced rules for generating sensors types based on generated user sensors so that the creator pipe applies additional creator pipes to the new sensors accordingly
						
						
						//check if the rule has been set to generate users from generated user sensors 
						if(generateUsersFromUsersAdaptorType!=null && !generateUsersFromUsersAdaptorType.isEmpty()){
							if(generateUsersFromUsersAdaptorType.equalsIgnoreCase("all")){ //all adaptors are required
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("user")){//if the adaptor type supports user sensors
										sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_USERS_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateUsersFromUsersAdaptorType)){ //just use the specified adaptor type
								sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_USERS_PROPERTY, generateUsersFromUsersAdaptorType);
							}

						}

						//if the rule has been set to generate entities from generated users sensors
						if(generateEntitiesFromUsersAdaptorType!=null && !generateEntitiesFromUsersAdaptorType.isEmpty()){
							if(generateEntitiesFromUsersAdaptorType.equalsIgnoreCase("all")){
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("entity")){//if the adaptor type supports entity sensors
										sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_USERS_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateEntitiesFromUsersAdaptorType)){
								sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_USERS_PROPERTY, generateEntitiesFromUsersAdaptorType);

							}
						}

						//if the rule has been set to generate locations from generated user sensors
						if(generateLocationsFromUsersAdaptorType!=null && !generateLocationsFromUsersAdaptorType.isEmpty()){
							if(generateLocationsFromUsersAdaptorType.equalsIgnoreCase("all")){
								for (String adname : sensors.keySet()) {
									if(sensors.get(adname).getSpecification().contains("location")){//if the adaptor type supports location sensors
										sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_USERS_PROPERTY, adname);
									}
								}
							}else if(sensors.containsKey(generateLocationsFromUsersAdaptorType)){
								sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_USERS_PROPERTY, generateLocationsFromUsersAdaptorType);
							}
						

						}
						
						if(!userPipes.isEmpty()){
							String[] userPipesArr = userPipes.split("\\.");
							if(userPipesArr.length==3){
								String userpipeAdaptorName = userPipesArr[0];
								String userpipeType = userPipesArr[1];
								String userserviceName = userPipesArr[2];
								if(pipes.containsKey(userpipeAdaptorName)){
									AbstractPipeAdaptor userPipeAdaptor = (AbstractPipeAdaptor) pipes.get(userpipeAdaptorName);
//									System.out.println("have userpipe adaptor: " +(userPipeAdaptor==null));
									IPipeService userPipe = userPipeAdaptor.createIPipe(userserviceName);
									sensorCreatorPipe.setProperty("pipe", userPipe.getID()+"");
								}
							}					
						}
					}
				}


			}else if(sensors.containsKey(rule)){ //the adaptor type has been specified
				IPipeService sensorCreatorPipe = basicPipeAdaptor.createIPipe("usersensorcreator");
				pipeline += sensorCreatorPipe.getID()+";";
				sensorCreatorPipe.setProperty("sensorType", "user");
				sensorCreatorPipe.setProperty("networktype", rule);
				//check for advanced rules for generating sensors types based on generated user sensors so that the creator pipe applies additional creator pipes to the new sensors accordingly
				
				
				//check if the rule has been set to generate users from generated user sensors 
				if(generateUsersFromUsersAdaptorType!=null && !generateUsersFromUsersAdaptorType.isEmpty()){
					if(generateUsersFromUsersAdaptorType.equalsIgnoreCase("all")){ //all adaptors are required
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("user")){//if the adaptor type supports user sensors
								sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_USERS_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateUsersFromUsersAdaptorType)){ //just use the specified adaptor type
						sensorCreatorPipe.setProperty(GENERATE_USERS_FROM_USERS_PROPERTY, generateUsersFromUsersAdaptorType);
					}

				}

				//if the rule has been set to generate entities from generated user sensors
				if(generateEntitiesFromUsersAdaptorType!=null && !generateEntitiesFromUsersAdaptorType.isEmpty()){
					if(generateEntitiesFromEntitiesAdaptorType.equalsIgnoreCase("all")){
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("entity")){//if the adaptor type supports entity sensors
								sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_USERS_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateEntitiesFromUsersAdaptorType)){
						sensorCreatorPipe.setProperty(GENERATE_ENTITIES_FROM_USERS_PROPERTY, generateEntitiesFromUsersAdaptorType);

					}
				}

				//if the rule has been set to generate locations from generated user sensors
				if(generateLocationsFromUsersAdaptorType!=null && !generateLocationsFromUsersAdaptorType.isEmpty()){
					if(generateLocationsFromLocationsAdaptorType.equalsIgnoreCase("all")){
						for (String adname : sensors.keySet()) {
							if(sensors.get(adname).getSpecification().contains("location")){//if the adaptor type supports location sensors
								sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_USERS_PROPERTY, adname);
							}
						}
					}else if(sensors.containsKey(generateLocationsFromUsersAdaptorType)){
						sensorCreatorPipe.setProperty(GENERATE_LOCATIONS_FROM_USERS_PROPERTY, generateLocationsFromUsersAdaptorType);
					}
				

				}
				
				if(!userPipes.isEmpty()){
					String[] userPipesArr = userPipes.split("\\.");
					if(userPipesArr.length==3){
						String userpipeAdaptorName = userPipesArr[0];
						String userpipeType = userPipesArr[1];
						String userserviceName = userPipesArr[2];
						if(pipes.containsKey(userpipeAdaptorName)){
							AbstractPipeAdaptor userPipeAdaptor = (AbstractPipeAdaptor) pipes.get(userpipeAdaptorName);
//							System.out.println("have userpipe adaptor: " +(userPipeAdaptor==null));
							IPipeService userPipe = userPipeAdaptor.createIPipe(userserviceName);
							sensorCreatorPipe.setProperty("pipe", userPipe.getID()+"");
						}
					}					
				}
			
			}
		}
		return pipeline;
	}

}