package ie.ucd.sixth.core.cyber.pipe;

import ie.ucd.sixth.core.sensor.data.SensorData;

import java.util.HashMap;
import java.util.Map;

/*
 * Providence management utility that allows a composite pipe to keep track of changes it makes to sensor data as it passes through individual pipes
 */
public class CompositePipeProvidenceManager {
	
	Map<String, Change> changeMap; //TODO change to timestamp as key so changes can be ordered by when they happened

	
	
	public CompositePipeProvidenceManager(){
		changeMap = new HashMap<String, CompositePipeProvidenceManager.Change>();
	}
	
	
	/*
	 * this method should be called by the composite pipe after each individual pipe has processed a sensordata 
	 */
	public synchronized void addChange(String filterName, String filterType, SensorData inputData, SensorData outputData){
		Change change =  new Change(filterName, filterType, inputData, outputData);
		changeMap.put("whatever the timestamp is now", change);
	}
	
	
	/*
	 * allow the composite pipe to access the changes
	 */
	public synchronized Map<String, Change> getChanges(){
		return changeMap;
	}
	
	
	

	class Change{
		
		private String filterName = "";
		private String filterType = "";
		private SensorData inputData;
		private SensorData outputData;
		
		public Change(String filterName, String filterType, SensorData inputData, SensorData outputData){
			this.filterName = filterName;
			this.filterType = filterType;
			this.inputData = inputData;
			this.outputData = outputData;
		}

		public String getFilterName() {
			return filterName;
		}

		public String getFilterType() {
			return filterType;
		}

		public SensorData getInputData() {
			return inputData;
		}

		public SensorData getOutputData() {
			return outputData;
		}
		
		
	}

	
}
