package ie.ucd.sixth.core.cyber.pipe;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.service.IPipeService;

/*
 * all pipes map an input (sensorData) to an output (sensorData or null)
 */
public abstract class AbstractPipeService implements IPipeService {

	//the type of pipe eg: filter
	private String type;
	//the name of the pipe eg: klout
	private String name;
	//the id of the pipe
	private int id;

	//the adaptor for this pipe - used here to ensure API limits are not exceeded
	private AbstractPipeAdaptor pipeAdaptor;
	
	
	public AbstractPipeService(AbstractPipeAdaptor pipeAdaptor, String type, String pipeName, int id){
		this.type = type;
		this.name = pipeName;
		this.id = id;
		this.pipeAdaptor = pipeAdaptor;
	}

	@Override
	public String getType() {
		return type;
	}

	@Override
	public String getName() {
		return name;
	}
	
	@Override
	public int getID(){
		return id;
	}

}
