package ie.ucd.sixth.core.cyber.pipe;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.CyberSensorData;
import ie.ucd.sixth.core.cyber.adaptor.sensor.DataModel;
import ie.ucd.sixth.core.sensor.data.ISensorData;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Transformer/Fuser
 * A Fuser is a type of SIXTH PIPE that can add information related to a sensor data modality
 * passing the supplimented sensor data object on
 */
public abstract class AbstractFuserPipe extends AbstractPipeService{
	private static final Logger log = Logger.getLogger(AbstractFuserPipe.class.getName());

	static {
		log.setLevel(Level.OFF);
	}

	public static final String TYPE = "fuser";
	private String pipeName;


	public AbstractFuserPipe(AbstractPipeAdaptor adaptor, String pipeName, int id) {
		super(adaptor, TYPE, pipeName, id);
		this.pipeName = pipeName;
	}	

	/*
	 * the only property a fuser requires be set is the modality it needs
	 * to find additional information about
	 */
	@Override
	public void setProperty(String propertyName, String value){
		//depending on the implementation the property name may be at the end of a '.' separated string

		if(propertyName.contains(".")){
			String props[] = propertyName.split("\\.");
			propertyName = props[props.length-1];
		}
	}

	@Override
	public ISensorData pipeData(ISensorData data) {
		DataModel model = ((CyberSensorData)data).getDataModel();
		Map<String, String> sensorDataMap = data.getValues();
		Map<String, String> newDataMap = getRelatedData(model);	//this will use the adaptor for remote interaction	
		Set<String> dataSet = newDataMap.keySet();
		for (String key : dataSet) {
			String newKey = data.getSensedModality()+"."+pipeName+"."+key;
			sensorDataMap.put(newKey, newDataMap.get(key));
		}
		data.replaceValues(sensorDataMap);

		return data;
	}
	
	
	protected abstract Map<String, String> getRelatedData(DataModel model);


}
