package ie.ucd.sixth.core.cyber.pipe;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;

import java.util.logging.Level;
import java.util.logging.Logger;


/*
 * A Filter is a type of SIXTH PIPE that can
 * compare a sensordata modality value to a specified threshold and 
 * decide whether to allow it to pass through or not
 */
public abstract class AbstractFilterPipe extends AbstractPipeService{
	private static final Logger log = Logger.getLogger(AbstractFilterPipe.class.getName());
	
	static {
		log.setLevel(Level.FINEST);
	}

	public static final String TYPE = "filter";
	public static final String MODALITY_PROPERTY = "modality";
	
	//numeric filters
	public static final String NUMERIC_LESS_THAN = "lessthan";
	public static final String NUMERIC_GREATER_THAN = "greaterthan";
	public static final String NUMERIC_EQUALS = "equals";
	//text based filters 
	public static final String ENTITY_MATCHES = "matches";
	public static final String ENTITY_CONTAINS = "contains";
	//regional filters
	public static final String LOCATION_NAME_MATCHES = "locationnamematches";
	public static final String LATLONG_MATCHES = "latlongmatches";
	public static final String LOCATION_NAME_CONTAINS_COORDINATES = "locationnamecontainscoords";
	public static final String BOUNDING_BOX_CONTAINS_COORDINATES = "boundingboxcontainscoords";
	public static final String BOUNDING_BOX_CONTAINS_LOCATION_NAME = "boundingboccontainslocationname";
	//social filters
	public static final String USER_NAME_MATCHES = "usernamematches";
	public static final String USER_ID_MATCHES = "useridmatches";
	

	private String thresholdString = "";
	private String modalityString = "";

	public AbstractFilterPipe(AbstractPipeAdaptor adaptor, String pipeName, int pipeId) {
		super(adaptor, TYPE, pipeName, pipeId);
		System.out.println("standard pipe id: " + pipeId);
	}

	/*
	 * Every filter requires a threshold and a modality to be set
	 * E.g: threshold = 30 and modalityString = kloutScore
	 *      will result in all sensordata where users have a kloutscore > 30 (or <= if thats how it is implemented)
	 */
	@Override
	public void setProperty(String propertyName, String value){
		
		//some applications might send property name in the format type.property
		if(propertyName.contains(".")){
			String[] prop = propertyName.split("\\.");
			System.out.println("props:"  +prop.length);
			if(prop.length>1){
				System.out.println("updating property name");
				propertyName = prop[prop.length-1];
			}
		}
		if(propertyName.equalsIgnoreCase(MODALITY_PROPERTY)){
			this.modalityString = value;
			System.out.println("modality property: " + modalityString);
		}

	}
	
	public String getModality(){
		return modalityString;
	}

	public String getThreshold(){
		return thresholdString;
	}
}
