package ie.ucd.sixth.core.cyber.pipe;

import ie.ucd.sixth.core.cyber.adaptor.pipe.AbstractPipeAdaptor;
import ie.ucd.sixth.core.sensor.data.SensorData;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCompositePipe extends AbstractPipeService{

	public static final String TYPE = "composite";
	public static final String PROVIDENCE_MANAGER_STATE_PROPERTY = "providenceState";

	private CompositePipeProvidenceManager providenceManager; 
	private boolean providenceEnabled = false;

	private List<AbstractPipeService> pipeList; //TODO: change this to something orderable

	public AbstractCompositePipe(AbstractPipeAdaptor adaptor, String pipeName, int pipeId) {
		super(adaptor, TYPE, pipeName, pipeId);
		pipeList = new ArrayList<AbstractPipeService>();
		providenceManager = new CompositePipeProvidenceManager();
	}

	@Override
	public void setProperty(String propertyName, String value) {
		if(propertyName.equalsIgnoreCase(PROVIDENCE_MANAGER_STATE_PROPERTY)){
			if(value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true")){
				providenceEnabled = true;
			}
		}

	}

	/*
	 * TODO: decide what to do when pipe returns null instead of a sensorData (i.e., when a pipe fails, handle it)
	 */
	public SensorData applyPipes(SensorData sensorData){
		List<AbstractPipeService> localPipeList = getPipes();
		if(localPipeList!=null && !localPipeList.isEmpty()){
			for (AbstractPipeService iSensorDataPipe : localPipeList) {
				String pipeType = iSensorDataPipe.getType();
				if(pipeType.equalsIgnoreCase(AbstractCompositePipe.TYPE)){
					//TODO: work out what to do when someone wants to add a composite pipe to a composite pipe
				}else{
					AbstractPipeService pipe = iSensorDataPipe;
					SensorData outputSensorData = (SensorData) pipe.pipeData(sensorData);
					if(outputSensorData!=null){
						if(providenceEnabled){
							providenceManager.addChange(pipe.getName(), pipe.getType(), sensorData, outputSensorData);	//document change							
						}
						sensorData = outputSensorData; //enforce change to data before it reaches next pipe
					}
				}
			}
		}
		
		return sensorData;
	}

	/*
	 * add a new pipe to the composite pipe
	 * TODO: ensure that the pipe can be inserted at any place it wants
	 */
	private synchronized void addPipe(AbstractPipeService pipe){
		pipeList.add(pipe);
	}

	/*
	 * remove pipe from list
	 */
	private synchronized void removePipe(AbstractPipeService pipe){
		if(pipeList.contains(pipe)){
			pipeList.remove(pipe);
		}
	}

	/*
	 * get the most up to date version of the pipeslist
	 */
	private synchronized List<AbstractPipeService> getPipes(){
		return pipeList;
	}

}
