package ie.ucd.sixth.core.cyber.adaptor.sensor;

import ie.ucd.sixth.core.cyber.sensor.CyberSensor;

public abstract class RunnableAdaptorStream extends AbstractAdaptorStream implements Runnable{

	
	protected boolean threadStopped;

	public RunnableAdaptorStream(AbstractCyberAdaptor adaptor) {
		super(adaptor);
		// TODO Auto-generated constructor stub
	}
	@Override
	public void stream() {
		if (active) {
			shutdown();
		}
		if (!aggregateProperties.isEmpty()) {
			threadStopped = false;
			this.active = true;
			new Thread(this).start();
		}	
	}

	@Override
	public void shutdown() {
		if(active){
			this.active = false;
		}
		
	}

	@Override
	public void start() {
		if(active){
			shutdown();
		}
		stream();
		
	}

	@Override
	protected void queueStart(CyberSensor sensor) {
		start();
		
	}
	
//	protected int getFrequency(){
//		return getFrequency();
//	}
	protected void sleep(){
		try {
			Thread.sleep((getFrequency() * 1000)); // convert seconds to
			// milliseconds and wait
			// that long before next
			// request
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	protected int getFrequency() {
		// TODO Auto-generated method stub
		return 1;
	}

}
