package ie.ucd.sixth.core.cyber.adaptor.sensor;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * parse the xml request recieved from application
 */
public class ParseSensorProperties {
	private static final Logger log = Logger.getLogger(ParseSensorProperties.class.getName());
	
	static {
		log.setLevel(Level.OFF);
	}

	private Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);

	private String sensor_service;

	private HashMap<String, String> propertiesMap;

	private boolean isConfigure;

	private boolean isCreate;

	private String sensorType;

	private String service;

	private String sensorId;

	private String pipeServiceType;

	private String pipeType;

	private String pipeServiceName;

	private boolean isCreatePipe;

	private boolean isConfigurePipe;

	private String pipeId;


	public ParseSensorProperties(){

	}


	public void parse(String xmlString){
		System.out.println("trying to parse XML: " +xmlString);
		isConfigure = false;
		isCreate = false;
		isCreatePipe = false;
		isConfigurePipe = false;
		propertiesMap = new HashMap<String, String>();
		//		xmlString = "<configureSensor><sensor type=\'weatheryr.info\' id=\'234234234\'><property name=\'frequency\'>22</property><property name=\'searchText\'>All</property><property name=\'location\'>Dublin</property><property name=\'state\'>on</property></sensor><sensor type=\'weather.info\'><property name=\'frequency\'>22</property><property name=\'searchText\'>All</property><property name=\'location\'>Dublin</property><property name=\'state\'>on</property></sensor></configureSensor>";

		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

		try {
			DocumentBuilder db = dbf.newDocumentBuilder();


			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(xmlString));

			Document doc = db.parse(is);

			//check first node
			Node node = doc.getFirstChild();
			String command = node.getNodeName();
			logger.info("core.cyber.utils.general.parsesensorproperties... command node: " +command);

			if(command.equalsIgnoreCase("createSensor")){
				NodeList nodelist = node.getChildNodes();
				Node sensorNode = nodelist.item(0);
				if(sensorNode.getTextContent().contains(".")){ //taking care of new format i.e: sensortype.service
					sensor_service = sensorNode.getTextContent();
					String[] s = sensor_service.split(".");
					sensorType = s[0];
					service = s[1];
				}
				else{	//just to catch old format
					sensorType = sensorNode.getTextContent();
					Node serviceNode = nodelist.item(1);
					service = serviceNode.getTextContent();
				}
				isCreate = true;
				logger.info("parseSensorProperties create sensor: " +sensorType ) ;

			}
			else if(command.equalsIgnoreCase("createPipe")){
				NodeList nodelist = node.getChildNodes();
				Node sensorNode = nodelist.item(0);
				if(sensorNode.getTextContent().contains(".")){ //taking care of new format i.e: sensortype.service
					sensor_service = sensorNode.getTextContent();
					String[] s = sensor_service.split(".");
					sensorType = s[0];
					service = s[1];
				}
				else{	//just to catch old format
					pipeServiceType = sensorNode.getTextContent();
					Node typeNode = nodelist.item(1);
					pipeType = typeNode.getTextContent();
					Node nameNode = nodelist.item(2);
					pipeServiceName = nameNode.getTextContent();
				}
				isCreatePipe = true;
				logger.info("parseSensorProperties create sensor: " +sensorType ) ;

			}
			else if(command.equalsIgnoreCase("configureSensor") ){

				isConfigure = true;
				//root element
				Element rootElement = doc.getDocumentElement();
				logger.info("root element: " +rootElement.getNodeName());
				//list of elements
				NodeList elemList = doc.getElementsByTagName("sensor");
				if(elemList != null && elemList.getLength() >0){
					//					for(int i = 0; i< elemList.getLength(); i++){
					//get the sensor element
					Element sensorElement = (Element)elemList.item(0); //TODO: we are only handling one sensor at a time
					logger.info("sensorElement: " +sensorElement.getNodeName());

					//get the sensor type
					sensorType = sensorElement.getAttribute("type");
					logger.info("parseSensorProperties configure sensor: " +sensorType ) ;
					if(sensorType.contains(".")){ //this should be type.service
						String[] s = sensorType.split("\\.");
						logger.info("setting sensor type and service: " +s.length);
						for (String string : s) {
							log.info("s: " +string);
						}
						if(s.length>=1){
							this.sensorType = s[0].trim();
							this.service = s[1].trim();
							logger.info("new sensorType and service: " +sensorType +", " +service);
						}
					}

					//get the sensor id
					sensorId = sensorElement.getAttribute("id");
					logger.info("sensor id in parser: " +sensorId);


					NodeList propertyList = sensorElement.getElementsByTagName("property");

					if(propertyList!=null && propertyList.getLength()>0){
						for(int k =0; k<propertyList.getLength(); k++){
							Element propertyElement =(Element)propertyList.item(k);
							String propertyName = propertyElement.getAttribute("name");
							String propertyValue = propertyElement.getTextContent();
							logger.info("propertyName: " +propertyName+" property value: " +propertyValue);

							//add each property to the map
							addProperty(sensorType, propertyName, propertyValue);

						}//end of property
					}

				}
			}else if(command.equalsIgnoreCase("configurePipe")){
				isConfigurePipe = true;
				//root element
				Element rootElement = doc.getDocumentElement();
				logger.info("root element: " +rootElement.getNodeName());
				//list of elements
				NodeList elemList = doc.getElementsByTagName("service");
				if(elemList != null && elemList.getLength() >0){
					//					for(int i = 0; i< elemList.getLength(); i++){
					//get the sensor element
					Element serviceElement = (Element)elemList.item(0); //TODO: we are only handling one sensor at a time
					logger.info("serviceElement: " +serviceElement.getNodeName());

					//get the sensor type
					pipeServiceType = serviceElement.getAttribute("type");
					logger.info("parseSensorProperties configure pipe: " +pipeServiceType ) ;
//					if(sensorType.contains(".")){ //this should be type.service
//						String[] s = pipeServiceType.split("\\.");
//						logger.info("setting pipe type and service: " +s.length);
//						for (String string : s) {
//							log.info("s: " +string);
//						}
//						if(s.length>=1){
//							this.sensorType = s[0].trim();
//							this.service = s[1].trim();
//							logger.info("new sensorType and service: " +sensorType +", " +service);
//						}
//					}

					//get the sensor id
					pipeId = serviceElement.getAttribute("id");
					logger.info("pipe id in parser: " +pipeId);


					NodeList propertyList = serviceElement.getElementsByTagName("property");

					if(propertyList!=null && propertyList.getLength()>0){
						for(int k =0; k<propertyList.getLength(); k++){
							Element propertyElement =(Element)propertyList.item(k);
							String propertyName = propertyElement.getAttribute("name");
							String propertyValue = propertyElement.getTextContent();
							logger.info("propertyName: " +propertyName+" property value: " +propertyValue);

							//add each property to the map
							addProperty(pipeServiceType, propertyName, propertyValue);

						}//end of property
					}
				}
			}




		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public String getPipeId() {
		return pipeId;
	}


	public String getPipeServiceType() {
		return pipeServiceType;
	}


	public String getPipeType() {
		return pipeType;
	}


	public String getPipeServiceName() {
		return pipeServiceName;
	}


	//
	public String getSensorType() {
		return sensorType.trim();
	}

	//
	public String getService(){
		return service.trim();
	}


	public boolean isCreate(){
		return isCreate;
	}

	public boolean isConfigure(){
		return isConfigure;
	}

	public boolean isCreatePipe(){
		return isCreatePipe;
	}

	public boolean isConfigurePipe(){
		return isConfigurePipe;
	}

	public String getPropertyValue(String sensorType, String propertyName){
		String value =  propertiesMap.get(sensorType+"."+propertyName);
		logger.info("jmdns.cyber.parsesensorproperties... name: "+propertyName+" value: " +value);
		if(value!=null){
			return value;
		}
		else{
			return "";
		}
	}

	private void addProperty(String sensorType, String propertyName, String propertyValue){
		String key = sensorType+"."+propertyName;
		String value = propertyValue;
		propertiesMap.put(key, value);
	}


	public String getSensorId() {
		return sensorId;
	}


	public Map<String, String> getPropertiesMap() {
		return propertiesMap;
	}

//		just for testing
		public static void main(String[] args){
			String	xmlString = "<configureSensor><sensor type=\'weatheryr.info\'><property name=\'frequency\'>22</property><property name=\'searchText\'>All</property><property name=\'location\'>Dublin</property><property name=\'state\'>on</property></sensor><sensor type=\'weather.info\'><property name=\'frequency\'>22</property><property name=\'searchText\'>All</property><property name=\'location\'>Dublin</property><property name=\'state\'>on</property></sensor></configureSensor>";
			ParseSensorProperties parser = new ParseSensorProperties();
			parser.parse(xmlString);
		}


}


