package ie.ucd.sixth.core.cyber.adaptor.sensor;

import java.io.Serializable;

public class DataModel implements Serializable {
	
	String entityPath = null; 
	String locationNamePath = null; 
	String latitudePath = null; 
	String longitudePath = null;
	String UserIDPath = null;
	String UserNamePath = null;
	
	/**
	 * for social adaptors to specify the minimal data model
	 * @param entityPath
	 * @param locationNamePath
	 * @param latitudePath
	 * @param longitudePath
	 * @param UserIDPath
	 * @param UserNamePath
	 */
	public DataModel(String entityPath, String locationNamePath, String latitudePath, String longitudePath, String UserIDPath, String UserNamePath){
		this.entityPath = entityPath;
		this.locationNamePath = locationNamePath;
		this.latitudePath = latitudePath;
		this.longitudePath = longitudePath;
		this.UserIDPath = UserIDPath;
		this.UserNamePath = UserNamePath;
	}
	
	/**
	 * for non social adaptors to specify the minimal data model
	 * @param entityPath
	 * @param locationNamePath
	 * @param latitudePath
	 * @param longitudePath
	 */
	public DataModel(String entityPath, String locationNamePath, String latitudePath, String longitudePath){
		this.entityPath = entityPath;
		this.locationNamePath = locationNamePath;
		this.latitudePath = latitudePath;
		this.longitudePath = longitudePath;
	
	}

	public String getEntityPath() {
		return entityPath;
	}

	public String getLocationNamePath() {
		return locationNamePath;
	}

	public String getLatitudePath() {
		return latitudePath;
	}

	public String getLongitudePath() {
		return longitudePath;
	}

	public String getUserIDPath() {
		return UserIDPath;
	}

	public String getUserNamePath() {
		return UserNamePath;
	}
	


}
