package ie.ucd.sixth.core.cyber.adaptor.sensor;

import ie.ucd.sixth.core.cyber.sensor.CyberSensor;
import ie.ucd.sixth.core.cyber.sensor.EntityCyberSensor;
import ie.ucd.sixth.core.cyber.sensor.LocationCyberSensor;
import ie.ucd.sixth.core.cyber.sensor.UserCyberSensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.utils.SensorSpecification;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * each adaptor should maintain its own cybersensorfactory
 * which manages the creation and deletion of cyber sensors belonging to that adaptor
 * the factory should manage ID's to ensure that each sensor is uniquely identifiable
 */
public class CyberSensorFactory {
	private static final Logger logger = Logger.getLogger(CyberSensorFactory.class.getName());

	static {
		logger.setLevel(Level.OFF);
	}	

	private List<SensorSpecification> sensorList = null; 
	/*
	 * a map of all sensors for this adaptor
	 * each adaptor must maintain its own map for the individual types of sensors
	 * for use with the adaptor streams
	 */
	private HashMap<Integer, CyberSensor> sensorMap;
	private HashMap<String, SensorSpecification> senorSpecifications;
	private Random generator;
	private int globalID = 1;
	private AbstractCyberAdaptor adaptor;


	public CyberSensorFactory(AbstractCyberAdaptor adaptor, List<SensorSpecification> sensorList){
		sensorMap = new HashMap<Integer, CyberSensor>();
		generator = new Random();
		this.adaptor = adaptor;
		this.sensorList = sensorList;
		setupSensorTypes();

	}

	//must have create sensor method
	public ISensorNode createSensor(String sensorType){
		logger.info("in old create sensor method with sensor type: "+sensorType);
		int id = generateId();
		if(senorSpecifications.containsKey(sensorType)){
			if(sensorType.equalsIgnoreCase(LocationCyberSensor.TYPE)){
				LocationCyberSensor sensor = (LocationCyberSensor)(adaptor.nodeLookup(new NodeDescription(id, adaptor.getType(), sensorType)));
				sensor.sendSensorCreationConfirmation(id, sensorType);
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				logger.info("created location sensor");
				return sensor;
			}else if(sensorType.equalsIgnoreCase(EntityCyberSensor.TYPE)){
				EntityCyberSensor sensor = (EntityCyberSensor)(adaptor.nodeLookup(new NodeDescription(id, adaptor.getType(), sensorType)));
				sensor.sendSensorCreationConfirmation(id, sensorType);
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				logger.info("created entity sensor");
				return sensor;
			}else if(sensorType.equalsIgnoreCase(UserCyberSensor.TYPE)){
				UserCyberSensor sensor = (UserCyberSensor)(adaptor.nodeLookup(new NodeDescription(id, adaptor.getType(), sensorType)));
				sensor.sendSensorCreationConfirmation(id, sensorType);
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				logger.info("created user sensor");
				return sensor;
			}
		

		}

		return null;
	}

	//	public abstract ISensorNode createSensor(AbstractCyberAdaptor adaptor, String sensorType, int id);
	public ISensorNode createSensor(AbstractCyberAdaptor ad, String sensorType, int id){
		logger.info("creating sensor in sensor factory (new method)...");
		logger.info("sensorType in createSensor: "+ad.getInfo().getName()+"." +sensorType);
		if(senorSpecifications.containsKey(sensorType)){
			if(sensorType.equalsIgnoreCase(LocationCyberSensor.TYPE)){

				LocationCyberSensor sensor = new LocationCyberSensor(adaptor, id, senorSpecifications.get(sensorType));
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				return sensor;	
			}else if(sensorType.equalsIgnoreCase(UserCyberSensor.TYPE)){
				UserCyberSensor sensor = new UserCyberSensor(adaptor, id, senorSpecifications.get(sensorType));
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				return sensor;	
			}else if(sensorType.equalsIgnoreCase(EntityCyberSensor.TYPE)){
				EntityCyberSensor sensor = new EntityCyberSensor(adaptor, id, senorSpecifications.get(sensorType));
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				return sensor;	
			}else{
				CyberSensor sensor = new CyberSensor(adaptor, id, sensorType, senorSpecifications.get(sensorType));
				addSensor(id, sensor);
				adaptor.addSensorToMapType(sensor, sensorType);
				return sensor;	
			}
		}

		return null;
	}


	/*
	 * delete a sensor maintained by this factory
	 * specifiy sensorType to ensure correct item deleted
	 * if sensor id and type do not correlate nothing will be deleted
	 */
	public void deleteSensor(int sensorId, String sensorType) {
		if(sensorMap.containsKey(sensorId)){
			CyberSensor sensor = sensorMap.get(sensorId);
			String type = sensor.getSensorType();
			if(type.equalsIgnoreCase(sensorType)){
				removeSensor(sensorId, sensor);
			}

		}

	}


	/*
	 * add the newly generated sensor to the map so we can keep track of sensors and ID's produced
	 */
	protected void addSensor(int id, CyberSensor sensor){
		sensorMap.put(id, sensor);
		logger.info("cybersensorfactory.. added sensor to map");
	}

	/*
	 * remove a specific sensor from the map
	 */
	protected synchronized void removeSensor(int id, CyberSensor sensor){
		sensorMap.remove(id);
	}

	/*
	 * generate a new Id that is unique for this adaptor
	 */
	public int generateId(){
		int id = 0;
		Set<Integer> idset = sensorMap.keySet();
		id = generator.nextInt();
		if(!idset.contains(id)){
			logger.info("generated id: " +id);
			return id;
		}else{
			logger.info("already have that id ("+id+") so we need a new one..");
			generateId();
		}

		return -1;
	}

	public int getNumSensors(){
		return sensorMap.keySet().size();
	}

	public void setupSensorTypes() {
		senorSpecifications = new HashMap<String, SensorSpecification>();
		for (SensorSpecification sensorSpec : sensorList) {
			senorSpecifications.put(sensorSpec.getName(), sensorSpec);
		}

	}


}
