package ie.ucd.sixth.core.cyber.adaptor.sensor;

import ie.ucd.sixth.core.utils.Property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateProperty {
	
	private Map<String, String> map;
	//each unique value for this property and how often it occurs
	private Map<String, List<Integer>> valuesAndSensors;
	private String name;
	private String type;

	public AggregateProperty(String propertyName, Property property) {
		this.map = property.getMap();
		this.name = property.getName();
		this.type = property.getType();
		valuesAndSensors = new HashMap<String, List<Integer>>();
	}

	public synchronized boolean addValue(String Value, int sensorID){
		if(Value==null || Value.isEmpty() || Value.equalsIgnoreCase(" ")){
			return false;
		}
		if(valuesAndSensors.containsKey(Value)){
			//add the sensorID to the list of sensors interested in this value:
			valuesAndSensors.get(Value).add(sensorID);
			return false; //the value is used by another sensor we dont make any change to values
		}else{
			
			List<Integer> sensorIDList = new ArrayList<Integer>();
			sensorIDList.add(sensorID);
			valuesAndSensors.put(Value, sensorIDList);
			return true; //the value is newly added so values have changed
		}
		
	}

	public Map<String, String> getMap() {
		return map;
	}

	public Map<String, List<Integer>> getValueFrequencies() {
		return valuesAndSensors;
	}
	
	public Set<String> getValues(){
		return getValueFrequencies().keySet();
	}

	

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}
	
	public boolean checkSensorForValue(String value, int sensorID){
		if(valuesAndSensors.containsKey(value)){
			if(valuesAndSensors.get(value).contains(sensorID)){
				return true;
			}
		}
		return false;
		
	}
	
	public List<Integer> getSensorsForValue(String value){
		if(valuesAndSensors.containsKey(value)){
			return valuesAndSensors.get(value);
		}
		return null;
	}


}
