package ie.ucd.sixth.core.cyber.adaptor.sensor;

import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.RetaskingMsg.COMMANDTYPE;
import ie.ucd.sixth.core.SensorStatus;
import ie.ucd.sixth.core.adaptor.AbstractSensorAdaptor;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.cyber.sensor.CyberSensor;
import ie.ucd.sixth.core.cyber.sensor.EntityCyberSensor;
import ie.ucd.sixth.core.cyber.sensor.InfrastructureAbstraction;
import ie.ucd.sixth.core.cyber.sensor.LocationCyberSensor;
import ie.ucd.sixth.core.cyber.sensor.NetworkAbstraction;
import ie.ucd.sixth.core.cyber.sensor.UserCyberSensor;
import ie.ucd.sixth.core.discovery.IAdaptorAccess;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IPipeService;
import ie.ucd.sixth.core.utils.AdaptorSpecification;
import ie.ucd.sixth.core.utils.AdaptorSpecificationParser;
import ie.ucd.sixth.core.utils.ParseSensorProperties;
import ie.ucd.sixth.core.utils.Property;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;





public abstract class AbstractCyberAdaptor extends AbstractSensorAdaptor {

	private static final Logger log = Logger.getLogger(AbstractCyberAdaptor.class.getName());

	static {
		log.setLevel(Level.OFF);
	}

	public Map<Integer, NetworkAbstraction> networkAbstractionMap;

	private BundleContext bundleContext;
	private Bundle bundle;
	protected CyberSensorFactory factory;
	protected HashMap<String, List<CyberSensor>> sensorMap;
	protected AbstractAdaptorStream streamAdaptor;

	private Map<Integer, InfrastructureAbstraction> infrastructureAbstractionMap;

	public AbstractCyberAdaptor(BundleContext bundleContext, String type) {
		super(bundleContext, type);
		this.bundleContext = bundleContext;
		this.bundle = bundleContext.getBundle();
	}

	@Override
	protected void init(BundleContext bundleContext, String type) {
		sensorMap = new HashMap<String, List<CyberSensor>>();
		networkAbstractionMap = new HashMap<Integer, NetworkAbstraction>();
		infrastructureAbstractionMap = new HashMap<Integer, InfrastructureAbstraction>();
		this.bundleContext = bundleContext;
		this.bundle = bundleContext.getBundle();
		super.init(bundleContext, type);
	}

	protected void delegatePropertiesToSensor(CyberSensor sensor, Map<String, String> propertiesMap){
		for(Entry<String, String> property: propertiesMap.entrySet()){
			String propertyName = property.getKey();
			String propertyValue = property.getValue();
			sensor.setSensorProperty(propertyName, propertyValue);
		}
	}

	public abstract void delegate(String message);

	@Override
	public ISensorNode nodeLookup(NodeDescription  id) {
		int sensorID =id.getID();
		log.finest("id="+sensorID);

		ISensorNode sensor = sensors.get(sensorID);
		if (sensor == null) {

			String sensorType = id.getSensorType();
			log.info("sensortype: " +sensorType);
			log.info("is factory null: " +(factory ==null));
			log.info("factory type: " +factory.getClass().getName());
			log.info("number of sensors maintained by factory: " +factory.getNumSensors());
			//get sensor from factory
			sensor = factory.createSensor(this, sensorType, sensorID);
			log.info("is sensor null? "+(sensor==null));
			if(sensor!=null){
				if (discovery != null){
					discovery.getNodeDiscovery().addNode(sensor);
				}
				sensors.put(sensorID, sensor);
				sendToReceivers(sensor, SensorStatus.NEW.toString());

			}
		}
		return sensor;
	}



	@Override
	public boolean retask(RetaskingMsg message){
		log.info(message.getAdaptor().getName()+" <= adaptor from message.... adaptor receiving message =>"+this.getInfo().getName()+" message contents: " +message.toString());
		log.info(message.toString());
		if (message.getCommandType().equals(COMMANDTYPE.RETASK)) {
			log.info("received " + message.getSensor()+", "+message.getCommandType());
			String messageString = (String)message.getObject();
			String sensor = message.getSensor();
			COMMANDTYPE e = message.getCommandType();
			int id = message.getNodeID();
			log.info("node id " + id);

			ParseSensorProperties parse = new ParseSensorProperties();
			parse.parse(messageString);
			
			if(parse.isCreateInfrastructure()){
				log.info("command is to create  a new infrastructure");
				String networkType = parse.getNetworkType().trim();
				String sensorType = parse.getSensorType().trim();
				log.info("checking if this adaptor needs to create any sensors for infrastructure with defined base network type: " +networkType);
				if(this.getInfo().getName().equalsIgnoreCase(networkType)){ //check if this network needs to generate the base sensor
					log.info("creating infrastructure with base: " +networkType + " from sensor type: "+sensorType );

					if(sensorType.equalsIgnoreCase(EntityCyberSensor.TYPE)){
						EntityCyberSensor newSensor = (EntityCyberSensor) factory.createSensor(sensorType);
						createInfrastrucure(newSensor);
					}else if(sensorType.equalsIgnoreCase(LocationCyberSensor.TYPE)){
						LocationCyberSensor newSensor = (LocationCyberSensor) factory.createSensor(sensorType);
						createInfrastrucure(newSensor);
					}else if(sensorType.equalsIgnoreCase(UserCyberSensor.TYPE)){
						UserCyberSensor newSensor = (UserCyberSensor) factory.createSensor(sensorType);
						createInfrastrucure(newSensor);
					}
				}
			}

			if(parse.isCreateNetwork()){
				log.info("command is to create  a new network");

				String sensorType = parse.getSensorType().trim();
				String networkType = parse.getNetworkType().trim();
				log.info("creating network of type " +networkType + " from sensor type: "+sensorType );
				if(sensorType.equalsIgnoreCase(EntityCyberSensor.TYPE)){
					EntityCyberSensor newSensor = (EntityCyberSensor) factory.createSensor(sensorType);
					createNetwork(newSensor);
				}else if(sensorType.equalsIgnoreCase(LocationCyberSensor.TYPE)){
					LocationCyberSensor newSensor = (LocationCyberSensor) factory.createSensor(sensorType);
					createNetwork(newSensor);
				}else if(sensorType.equalsIgnoreCase(UserCyberSensor.TYPE)){
					UserCyberSensor newSensor = (UserCyberSensor) factory.createSensor(sensorType);
					createNetwork(newSensor);
				}
			}
			if(parse.isConfigureNetwork()){
				log.info("command is to configure a network");

				String networkType = parse.getNetworkType().trim();
				String networkToConfigureId = parse.getNetworkID();
				configureNetwork(networkToConfigureId, parse.getPropertiesMap());

			}
			if(parse.isConfigureInfrastructure()){
				log.info("command is to configure an infrastructure");

				String networkType = parse.getNetworkType().trim();
				String infrastructureToConfigureId = parse.getInfrastructureID();
				configureInfrastructure(infrastructureToConfigureId, parse.getPropertiesMap());
			}
			if(parse.isCreateSensor()){
				log.info("command is to create a new sensor");

				String sensorType = parse.getSensorType().trim();
				String serviceType = parse.getService().trim();
				CyberSensor newSensor = (CyberSensor) factory.createSensor(serviceType);

			}if(parse.isConfigureSensor()){
				log.info("command is to configure a sensor");

				String sensorType = parse.getSensorType().trim();

				String serviceType = parse.getService();
				String sensorToConfigureId = parse.getSensorId();
				log.info("configuring sensor: sensorType: "+sensorType+" service type: "+serviceType+" sensor id: "+sensorToConfigureId);
			
				List<ISensorNode> infos = getNodes(serviceType);
				if (!infos.isEmpty()) {
					for (ISensorNode sens : infos) {

						CyberSensor mySensor = (CyberSensor) sens;
						if((sensorToConfigureId.trim()).equalsIgnoreCase(mySensor.getID()+"".trim())){
							//have found the correct sensor so need to check for updated values for each property
							List<Property> properties = mySensor.getProperties();
							String stateValue = "";
							for (Property property : properties) {
								//check if this property is being updated
								if(!parse.getPropertyValue(sensorType, property.getName()).isEmpty()){
									if(property.getName().equalsIgnoreCase(CyberSensor.STATEPROPERTY)){
										stateValue = parse.getPropertyValue(sensorType, property.getName());
									}else{
										mySensor.setSensorProperty(property.getName(), parse.getPropertyValue(sensorType, property.getName()));
									}
								}
							}
							mySensor.setSensorProperty(CyberSensor.STATEPROPERTY, stateValue);
							addSensorToStreamAdaptor(mySensor, serviceType);
						}
					}
				}

			}else{
				//create and configure are taken care of by default - if any adaptor wants to extend these options 
				//they implement retasking message response in the delegate method
				delegate((String)message.getObject());	

			}
		}


		return true; // return true if you accept the message and will perform the action
	}
	
	public void createInfrastrucure(CyberSensor newSensor){ //for now all infrastrucutures have a specific base sensor
		InfrastructureAbstraction infrastructure = new InfrastructureAbstraction(this, newSensor);
		infrastructureAbstractionMap.put(newSensor.getID(), infrastructure);
		System.out.println("have added abstraction to map .... " +infrastructureAbstractionMap.size());
	}

	public void createNetwork(CyberSensor newSensor) {
		NetworkAbstraction network = new NetworkAbstraction(this, newSensor);
		networkAbstractionMap.put(newSensor.getID(), network);
	}
	
	public void configureInfrastructure(String sensorToConfigureId, HashMap<String, String> propertiesMap){
		log.info("configuring network with base id: " +sensorToConfigureId);
		int sensorInt = Integer.parseInt(sensorToConfigureId);
		InfrastructureAbstraction abstraction = infrastructureAbstractionMap.get(sensorInt);
		String stateString = "";
		for (String property : propertiesMap.keySet()) {
			log.info("is abstraction null??? " +(abstraction==null));
			abstraction.setProperty(property, propertiesMap.get(property));
		}

		abstraction.startInfrastructure();
	}

	public void configureNetwork(String sensorToConfigureId, HashMap<String, String> propertiesMap) {
		log.info("configuring network with base id: " +sensorToConfigureId);
		int sensorInt = Integer.parseInt(sensorToConfigureId);
		NetworkAbstraction abstraction = networkAbstractionMap.get(sensorInt);
		String stateString = "";
		for (String property : propertiesMap.keySet()) {
			abstraction.setProperty(property, propertiesMap.get(property));
		}

		abstraction.startNetwork();
	}		


	/*
	 * register the sensor factory for a specific adaptor
	 */
	public void registerFactory(CyberSensorFactory factory){
		bundleContext.registerService(factory.getClass().getName(), factory, null);
		this.factory = factory;

	}

	/*
	 * provide functionality that adds a sensor to the relevant adaptor stream
	 * if the relevant stream has not been created yet it should be
	 */
	public void addSensorToStreamAdaptor(CyberSensor sensor, String sensorType){
		streamAdaptor.addSensor(sensor);
	}

	public ISensorNode createSensor(String type){
		return factory.createSensor(type);
	}

	public Map<String, ISensorAdaptor> getSensorAdaptorMap(){
		Map<String, ISensorAdaptor> pipeMap = new HashMap<String, ISensorAdaptor>();
		IAdaptorAccess adaptorAccess = discovery.getAdaptorAccess();
		List<ISensorAdaptor> sensorList = adaptorAccess.getSensorAdaptors(); 
		for (ISensorAdaptor isensorAdaptor : sensorList) {
			String name = isensorAdaptor.getInfo().getName();
			pipeMap.put(name, isensorAdaptor);
		}
		return pipeMap;
	}
	public Map<String, IPipeAdaptor> getPipeMap(){
		Map<String, IPipeAdaptor> pipeMap = new HashMap<String, IPipeAdaptor>();
		IAdaptorAccess adaptorAccess = discovery.getAdaptorAccess();
		List<IPipeAdaptor> pipeList = adaptorAccess.getPipeAdaptors(); 
		for (IPipeAdaptor iPipeAdaptor : pipeList) {
			String type = iPipeAdaptor.getType();
			pipeMap.put(type, iPipeAdaptor);
		}
		return pipeMap;
	}

	public List<IPipeService> getPipeList(int[] pipeIDs){
		IPipeService[] pipeServices = new IPipeService[pipeIDs.length];		
		//we have no way of checking what type the pipe id is so we have to check every adaptor
		Map<String, IPipeAdaptor> pipeMap = getPipeMap();//map of all adaptors
		Set<String> pipeSet = pipeMap.keySet();
		for (String string : pipeSet) { //for each pipe adaptor
			IPipeAdaptor adaptor = pipeMap.get(string);//resolve the adaptor
			Map<Integer, IPipeService> adaptorPipes = adaptor.getPipes(); //get all pipes belonging to this adaptor
			for(int i =0; i<pipeIDs.length; i++){ //check if any of our pipes belong to this adaptor
				if(adaptorPipes.containsKey(pipeIDs[i])){
					IPipeService pipe = adaptor.getPipe(pipeIDs[i]);
					if(pipe!=null){
						pipeServices[i] = pipe;
					}
				}

			}

		}
		List<IPipeService> pipeList = Arrays.asList(pipeServices);
		return pipeList;
	}

	public void addSensorToMapType(CyberSensor sensor, String sensorType) {
		if(sensorMap.containsKey(sensorType)){
			if(sensorMap.get(sensorType)!=null){
				sensorMap.get(sensorType).add(sensor);
			}

		}

	}

	public void setupSensorFactory(AbstractCyberAdaptor adaptor){
		AdaptorSpecification cred = AdaptorSpecificationParser.parse(getSpecification());
		factory = new CyberSensorFactory(adaptor, cred.getList());
	}

	public abstract DataModel getDataModel();


}
