package ie.ucd.sixth.core.cyber.adaptor.pipe;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PipeConfigurationParser {
	private static final Logger log = Logger.getLogger(PipeConfigurationParser.class.getName());
	
	static {
		log.setLevel(Level.SEVERE);
	}

	private HashMap<String, String> propertiesMap;
	private boolean isConfigure;
	private boolean isCreate;
	private String pipeType; //fuser/filter/transformer/learner
	private String serviceType; //name of bundle e.g. klout
	private String pipeID; //the id of the pipe instance
	private String serviceName; // the name of the specific pipe e.g. "TwitterScreenName_KloutUserData_Fuser"
	private String pipeService;

	public void parse(String xml) {
		isConfigure = isCreate = false;
		propertiesMap = new HashMap<String, String>();
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

		try {
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(xml));
			Document doc = db.parse(is);

			Node node = doc.getFirstChild();
			String command = node.getNodeName();
			log.info("Command node: " + command);

			if (command.equalsIgnoreCase("createPipe")) {
				NodeList nodelist = node.getChildNodes();
				Node sensorNode = nodelist.item(0);
				pipeType = sensorNode.getTextContent();
				Node serviceTypeNode = nodelist.item(1);
				serviceType = serviceTypeNode.getTextContent();
				Node serviceNameNode = nodelist.item(2);
				serviceName = serviceNameNode.getTextContent();
				isCreate = true;
				log.info("parseSensorProperties create sensor: "
						+ pipeType);
				log.info("Pipe Type " + pipeType);
				log.info("Service Type " + serviceType);
				log.info("Service Name " + serviceName);
			} else if (command.equalsIgnoreCase("configurePipe")) {
				log.info("here i am");
				isConfigure = true;
				// root element
				Element rootElement = doc.getDocumentElement();
				log.info("root element: " + rootElement.getNodeName());
				// list of elements
				NodeList elemList = doc.getElementsByTagName("service");
				if (elemList != null && elemList.getLength() > 0) {
					// for(int i = 0; i< elemList.getLength(); i++){
					// get the sensor element

					// TODO: we are only handling one sensor at a time
					Element sensorElement = (Element) elemList.item(0);
					log.info("sensorElement: " + sensorElement.getNodeName());

					pipeType = sensorElement.getAttribute("type");
					log.info("pipe type " + pipeType);
					pipeID = sensorElement.getAttribute("id");
					log.info("pipe id: " + pipeID);
					pipeService = sensorElement.getAttribute("service");
					log.info("pipe service: " + pipeService);

					NodeList propertyList = sensorElement
							.getElementsByTagName("property");

					if (propertyList != null && propertyList.getLength() > 0) {
						for (int k = 0; k < propertyList.getLength(); k++) {
							Element propertyElement = (Element) propertyList
									.item(k);
							String propertyName = propertyElement
									.getAttribute("name");
							String propertyValue = propertyElement
									.getTextContent();
							log.info("propertyName: " + propertyName
									+ " property value: " + propertyValue);

							// add each property to the map
							addProperty(propertyName, propertyValue);

						}// end of property
					}

				}
			}

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public String getSensorType() {
		return pipeType.trim();
	}

	public String getService() {
		return serviceType.trim();
	}

	public boolean creationMessage() {
		return isCreate;
	}

	public String getPropertyValue(String sensorType, String propertyName) {
		String value = propertiesMap.get(sensorType + "." + propertyName);
		if (value != null) {
			return value;
		} else {
			return "";
		}
	}

	private void addProperty(String sensorType, String propertyName,
			String propertyValue) {
		String key = sensorType + "." + propertyName;
		String value = propertyValue;
		propertiesMap.put(key, value);
	}
	
	private void addProperty(String propertyName,
			String propertyValue) {
//		String key = sensorType + "." + propertyName;
		String key = propertyName;
		String value = propertyValue;
		propertiesMap.put(key, value);
	}

	public String getPipeID() {
		return pipeID.trim();
	}

	public void print() {
		for (String key : propertiesMap.keySet()) {
			log.info("Property: " + key + " value: "
					+ propertiesMap.get(key));
		}
	}

	public String getServiceName() {
		return serviceName;
	}

	public HashMap<String, String> getPropertiesMap() {
		return propertiesMap;
	}

	public String getPipeType() {
		return pipeType;
	}

	public String getServiceType() {
		return serviceType;
	}

	public String getPipeService() {
		return pipeService;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}
	
	public boolean configurationMessage() {
		return isConfigure;
	}

	public static void main(String[] args) {
		//service type = bundle name; pipeType = type of pipe; serviceName = Name of Fuser class to be used
		String create = "<createPipe><serviceType>Klout</serviceType><pipeType>Fuser</pipeType><serviceName>TwitterScreenName_KloutUserData_Fuser</serviceName></createPipe>";
		String config = "<configurePipe><service type=\'Klout\' id=\'523452435\'><property name=\'modality\'>tweet.user.screenname</property></service></configurePipe>";
//		String config = "<configurePipe><pipe type=\'Klout\' id=\'10\' service=\'fuser\'><property name=\'frequency\'>22</property><property name=\'searchText\'>All</property><property name=\'location\'>Dublin</property><property name=\'state\'>on</property></pipe><pipe name=\'Klout\' id=\'10\' type=\'fuser\'><property name=\'frequency\'>22</property><property name=\'searchText\'>All</property><property name=\'location\'>Dublin</property><property name=\'state\'>on</property></pipe></configurePipe>";
		PipeConfigurationParser parser = new PipeConfigurationParser();
		parser.parse(config);
		parser.print();
	}

}
