package ie.ucd.sixth.core.cyber.adaptor.pipe;



import ie.ucd.sixth.core.cyber.pipe.AbstractPipeService;
import ie.ucd.sixth.core.service.IPipeService;

import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

/*
 * each adaptor should maintain its own cybersensorfactory
 * which manages the creation and deletion of cyber sensors belonging to that adaptor
 * the factory should manage ID's to ensure that each sensor is uniquely identifiable
 */
public abstract class AbstractPipeFactory {
	
	/*
	 * a map of all sensors for this adaptor
	 * each adaptor must maintain its own map for the individual types of sensors
	 * for use with the adaptor streams
	 */
	public HashMap<Integer, IPipeService> pipeMap;
	private Random generator;
	private int globalID = 1;

	
	public AbstractPipeFactory(AbstractPipeAdaptor adaptor){
		pipeMap = new HashMap<Integer, IPipeService>();
		generator = new Random();
		
	}
	
	//must have create sensor method
	public abstract IPipeService createPipe(String serviceName);
	
	public abstract IPipeService createPipe(AbstractPipeAdaptor adaptor, String serviceName, int id);
	

	/*
	 * delete a pipe maintained by this factory
	 * specifiy serviceName to ensure correct item deleted
	 * if pipe id and type do not correlate nothing will be deleted
	 */
	public void deletePipe(int pipeID, String serviceName) {
		if(pipeMap.containsKey(pipeID)){
			AbstractPipeService pipe = (AbstractPipeService) pipeMap.get(pipeID);
			String type = pipe.getName();
			if(type.equalsIgnoreCase(serviceName)){
				removeSensor(pipeID, pipe);
			}
			
		}
		
	}
	
	
	/*
	 * add the newly generated pipe to the map so we can keep track of pipe and ID's produced
	 */
	protected void addPipe(int id, AbstractPipeService pipe){
		pipeMap.put(id, pipe);
	}
	
	/*
	 * remove a specific pipe from the map
	 */
	protected void removeSensor(int id, AbstractPipeService pipe){
		pipeMap.remove(id);
	}
	
	/*
	 * generate a new Id that is unique for this adaptor
	 */
	public int generateId(){
		int id = 0;
		Set<Integer> idset = pipeMap.keySet();
		id = generator.nextInt();
		if(!idset.contains(id) && id!=0){
			return id;
		}else{
			generateId();
		}
		
		return -1;
	}
	
	public int getNumPipes(){
		return pipeMap.keySet().size();
	}
	


}
