package ie.ucd.sixth.core.cyber.adaptor.pipe;

import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.RetaskingMsg.COMMANDTYPE;
import ie.ucd.sixth.core.SIXTH;
import ie.ucd.sixth.core.SensorStatus;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.application.IApplication;
import ie.ucd.sixth.core.cyber.adaptor.sensor.ParseSensorProperties;
import ie.ucd.sixth.core.cyber.pipe.AbstractPipeService;
import ie.ucd.sixth.core.discovery.IAdaptorAccess;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IDiscoveryHandler;
import ie.ucd.sixth.core.discovery.RetentionPolicyManager;
import ie.ucd.sixth.core.monitor.DataReceiverMonitor;
import ie.ucd.sixth.core.monitor.DiscoveryReceiverMonitor;
import ie.ucd.sixth.core.monitor.RetaskingReceiverMonitor;
import ie.ucd.sixth.core.receiver.IAdaptorReceiver;
import ie.ucd.sixth.core.receiver.ICredentialedReceiver;
import ie.ucd.sixth.core.receiver.IDataReceiver;
import ie.ucd.sixth.core.receiver.INodeReceiver;
import ie.ucd.sixth.core.receiver.IRetaskingReceiver;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.SensorData;
import ie.ucd.sixth.core.service.IPipeAdaptor;
import ie.ucd.sixth.core.service.IPipeService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;

public abstract class AbstractPipeAdaptor implements IPipeAdaptor{
	private static final Logger log = Logger.getLogger(AbstractPipeAdaptor.class.getName());
	
	static {
		log.setLevel(Level.SEVERE);
	}

	private long timeout;
	protected BundleContext context;
	protected IDiscovery discovery;
	protected Map<Integer, ISensorNode> sensors = new HashMap<Integer, ISensorNode>();
	protected List<IApplication> applications;
	protected boolean registered = false;
	protected Timer timer;
	protected AdaptorInformation information;
	protected DiscoveryReceiverMonitor discoveryReceiverFinder;
	private List<COMMANDTYPE> commandList = new Vector<COMMANDTYPE>();
	private List<ISensorData> sensorData = new Vector<ISensorData>();
	private RetaskingReceiverMonitor retaskingReceiverMonitor;
	private RetentionPolicyManager retentionPolicyManager;
	

	protected List<IRetaskingReceiver> retaskingReceiver;
	private String type;
	protected Map<Integer, IPipeService> pipeMap = new HashMap<Integer, IPipeService>();
	protected AbstractPipeFactory factory;
	protected List<IDataReceiver> receivers;
	
	
	
//	private HashMap<Integer, AbstractPipeService> pipeMap = new HashMap<Integer, AbstractPipeService>();


	
	public AbstractPipeAdaptor(BundleContext bundleContext, String type) {
		init(bundleContext, type);
	}

	protected void init(BundleContext bundleContext, String type) {
		this.type = type;
		context = bundleContext;
		this.information = new AdaptorInformation(type,
				AdaptorInformation.PIPE_ADAPTOR);
		information.setSpec(getSpecification());
		initReceiverManagement();
		initCommandList();
		configureTimer();
//		retentionPolicyManager = new RetentionPolicyManager(this,
//				new DataRetensionPolicy(), 5000);
		discoveryRegistration();
	}

	private void initCommandList() {
		commandList.add(COMMANDTYPE.REQUESTFREQ);
		commandList.add(COMMANDTYPE.REQUESTVALUE);
		commandList.add(COMMANDTYPE.RETASK);
//		commandList.add(COMMANDTYPE.SETFREQ);
	}

	private void initReceiverManagement() {
		// TODO start using IApplication
		discoveryReceiverFinder = DiscoveryReceiverMonitor.getMonitor(context);
		discoveryReceiverFinder.addReceiver(this);
		applications = SIXTH.get(IApplication.class, context);
		retaskingReceiverMonitor = RetaskingReceiverMonitor.getMonitor(context);
		
	}

	@Override
	public void receive(ICredentialedReceiver receiver) {
		log.info("Added new Discovery Receiver: " + receiver);
		if (receiver instanceof IAdaptorReceiver) {
			((IAdaptorReceiver) receiver).receive(getInfo(), "Unchanged");
		}
		if (receiver instanceof INodeReceiver) {
			INodeReceiver moteReceiver = (INodeReceiver) receiver;
			for (ISensorNode sensorNode : sensors.values()) {
				moteReceiver.receive(sensorNode, SensorStatus.ON.toString());
				for (ISensor sensor : sensorNode.getSensors()) {
					moteReceiver.receive(sensor, SensorStatus.ON.toString());
				}
			}
		}
	}
	
	protected void discoveryRegistration() {
		IDiscoveryHandler handler = SIXTH.getDiscoveryHandler();
		discovery = handler.getDiscovery(SIXTH.PASS);
		discovery.registerAdaptor(this);
		AdaptorInformation info = getInfo();
		discoveryReceiverFinder.notify(getInfo(), SIXTH.ADAPTOR_NEW);
	}

	/**
	 * TODO figure out sets up timer task to ping sensors
	 */
	protected void configureTimer() {
		timer = new Timer();
		// timer.scheduleAtFixedRate(new Task(this), 5000, 5000);
	}	
	public void receiveDiscovery(IDiscoveryHandler handler) {
		discovery = handler.getDiscovery(SIXTH.PASS);
		if (!registered) {
			discovery.registerAdaptor(this);
			registered = true;
		}
	}

	@Override
	public void unregister() {
		discoveryReceiverFinder.notify(getInfo(), SIXTH.ADAPTOR_UNREGISTERING);

	}
	
	@Override
	public Map<Integer, IPipeService> getPipes() {
		return pipeMap;
	}

	@Override
	public boolean retask(RetaskingMsg message){
		log.info("retask() in abstractPipeAdaptor with message: " +message );
		
		if (message.getCommandType().equals(COMMANDTYPE.RETASK)) {
//			log.finest("received " + message.getVal());	
			delegate((String)message.getObject());
		}
		return true; // return true if you accept the message and will perform the action
	}
	
	
	@Override
	public String getType() {
		return type;
	}
	
	@Override
	public IPipeService getPipe(int id){
		log.info("getting pipe id="+id);
		return pipeMap.get(id);
	}

	private void delegate(String message) {
		log.info("PIPE: in delegate! Received: " + message);
//		PipeConfigurationParser parser = new PipeConfigurationParser();
		ParseSensorProperties parser = new ParseSensorProperties();
		parser.parse(message);		
	
		
		if(parser.isCreatePipe()){
			String serviceType = parser.getPipeServiceType();
			String pipeType = parser.getPipeServiceType();
			String pipeName = parser.getPipeServiceName();
			
			if(serviceType.equalsIgnoreCase(getType())){
				createPipe(pipeName); //create the appropriate pipe
			}
		}else if(parser.isConfigurePipe()){
			String serviceType = parser.getPipeServiceType();
			String pipeId = parser.getPipeId();
			
			int pipeIdInt = 0;
			if (serviceType.equalsIgnoreCase(getType())) {
				try{
					pipeIdInt = Integer.parseInt(pipeId);
				}catch(NumberFormatException e){
					log.severe("could not convert pipe id ("+pipeId+") to integer: " +e);
				}
				configurePipe(pipeIdInt, parser);				
			}
			
		}
	
	}
	
	/*
	 * register the sensor factory for a specific adaptor
	 */
	public void registerFactory(AbstractPipeFactory factory){
		context.registerService(factory.getClass().getName(), factory, null);
		this.factory = factory;

	}
	
	/**
	 * Sends {@link ISensorData} to all {@link IDataReceiver} instances
	 */
	public void send(ISensorData data) {
		log.info("Sending data: " + data + " to receivers");
		DataReceiverMonitor finder = DataReceiverMonitor.getMonitor(context);
		receivers = finder.getDataReceviers();
		/**
		 * might have to use sensor adaptor to enable communication between adaptors
		 * this can be used to physical sensor networks too, enabling the use of infrastructure 
		 */
		synchronized (receivers) {
			for (IDataReceiver receiver : receivers) {
				log.info("receivers: " +receiver);
				receiver.receive(data);
			}
		}
	}

	

	/*
	 * configure a pipe identifiable via its pipe id and
	 * according to the configurations identified by the parser 
	 */
	protected abstract void configurePipe(int pipeId, ParseSensorProperties parser);
	
	/*
	 * create a new pipe with matching service name
	 * a new instance of the pipe should be generated with a unique id
	 * and a confirmation message should be sent to the user so they can retrieve this id
	 * and use it in any (re)tasking messages they send to configure the pipe
	 */
	protected abstract void createPipe(String serviceName);

//	@Override
	public void serviceChanged(ServiceEvent event) {
		ServiceReference sr = event.getServiceReference();
		Object service = context.getService(sr);
		if (event.getType() == ServiceEvent.REGISTERED) {
			handleRegistration(service);
		} else if (event.getType() == ServiceEvent.UNREGISTERING) {
			handleUnregistering(service);
		} else if (event.getType() == ServiceEvent.MODIFIED) {
			// TODO look into this
		}
	}
	

	private void handleUnregistering(Object service) {
		if (service instanceof IDataReceiver) {
			receivers.remove(service);
		} else if (service instanceof IRetaskingReceiver) {
			retaskingReceiver.remove(service);
		}
	}

	private void handleRegistration(Object service) {
		if (service instanceof IDataReceiver) {
			if (!receivers.contains(service))
				receivers.add((IDataReceiver) service);
		}  else if (service instanceof IRetaskingReceiver) {
			if (!retaskingReceiver.contains(service))
				retaskingReceiver.add((IRetaskingReceiver) service);
		}
	}
	
	public void addPipeToMap(int pipeID, AbstractPipeService pipe){
		pipeMap.put(pipeID, pipe);
	}

	
	public IPipeService createIPipe(String serviceName){
		return factory.createPipe(serviceName);
	}
	
	@Override
	public AdaptorInformation getInfo() {
		return information;
	}

	/**
	 * the adaptor needs to perform the interactions with remote resource to ensure resource constraints are not exceeded
	 * @param pipename
	 * @param modalityValue
	 * @return
	 */
	public abstract Map<String, String> getResource(String pipename, String modalityValue);
	
	//TODO: move to abstract class
	public void sendSensorCreationConfirmation(int pipeID, String serviceType, String pipeType, String serviceName){
		String dataString = "<sixth><notification type='pipe created'><serviceType>"+serviceType+"</serviceType><pipeType>"+pipeType+"</pipeType><serviceName>"+serviceName+"</serviceName><pipeId>"+pipeID+"</pipeId></notification></sixth>";

		Map<String, String> map = new HashMap<String, String>();
		map.put("notification", "pipe created");
		map.put("serviceType", serviceType);
		map.put("pipeType", pipeType);
		map.put("serviceName", serviceName);
		map.put("pipeID", pipeID+"");
//		log.info("SENDING SERVICE CONFIRMATION");
		SensorData data = new SensorData(this.getType(), pipeID, "sixth.notification", map, SensorStatus.NEW.toString(), System.currentTimeMillis());
//		log.info("about to send pipe creation confirmation for pipe id: "+pipeID);
		send(data);
	}

	public Map<String, IPipeAdaptor> getPipeMap(){
		Map<String, IPipeAdaptor> pipeMap = new HashMap<String, IPipeAdaptor>();
		IAdaptorAccess adaptorAccess = discovery.getAdaptorAccess();
		List<IPipeAdaptor> pipeList = adaptorAccess.getPipeAdaptors(); 
		for (IPipeAdaptor iPipeAdaptor : pipeList) {
			String type = iPipeAdaptor.getType();
			pipeMap.put(type, iPipeAdaptor);
		}
		return pipeMap;
	}
	
	public Map<String, ISensorAdaptor> getSensorMap(){
		Map<String, ISensorAdaptor> pipeMap = new HashMap<String, ISensorAdaptor>();
		IAdaptorAccess adaptorAccess = discovery.getAdaptorAccess();
		List<ISensorAdaptor> sensorList = adaptorAccess.getSensorAdaptors(); 
		for (ISensorAdaptor isensorAdaptor : sensorList) {
			String name = isensorAdaptor.getInfo().getName();
			pipeMap.put(name, isensorAdaptor);
		}
		return pipeMap;
	}
}
