/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.twitterv2.utils;

import ie.ucd.sixth.adaptor.twitterv2.utils.StringProcessor;
import java.util.List;
import twitter4j.User;

public class UserToXMLConverter {
    private List<User> userList;
    private String userXMLString = "";
    private String userId = "";
    private StringProcessor processor;
    private String userName;
    private String screenName;

    public UserToXMLConverter() {
        this.processor = new StringProcessor();
    }

    public UserToXMLConverter(List<User> userList) {
        this.userList = userList;
        this.processor = new StringProcessor();
    }

    public String convertUserList() {
        String result = "<Users>";
        for (User u : this.userList) {
            result = String.valueOf(result) + this.convertUser(u);
        }
        result = String.valueOf(result) + "</Users>";
        return result;
    }

    public String convertUser(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<user>";
        this.addCreatedAt(u);
        this.addDescription(u);
        this.addFavouritesCount(u);
        this.addFollowersCount(u);
        this.addFriendsCount(u);
        this.addUserId(u);
        this.addPreferredLanguage(u);
        this.addListedCount(u);
        this.addUserLocation(u);
        this.addName(u);
        this.addProfileBackgroundColor(u);
        this.addProfileImageURL(u);
        this.addProfileLinkColor(u);
        this.addProfileSidebarBorderColor(u);
        this.addProfileSidebarFillColor(u);
        this.addProfileTextColor(u);
        this.addScreenName(u);
        this.addCurrentStatus(u);
        this.addStatusCount(u);
        this.addTimeZone(u);
        this.addUtcOffset(u);
        this.addIsContributorsEnabled(u);
        this.addIsFollowRequestSent(u);
        this.addIsGeoEnabled(u);
        this.addIsProfileBackgroundTiled(u);
        this.addIsProfileUseBackgroundImage(u);
        this.addIsProtected(u);
        this.addIsShowAllInlineMedia(u);
        this.addIstranslator(u);
        this.adIsVerified(u);
        this.userXMLString = String.valueOf(this.userXMLString) + "</user>";
        return this.userXMLString;
    }

    private void adIsVerified(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isVerified>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isVerified();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isVerified>";
    }

    private void addIstranslator(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isTranslator>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isTranslator();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isTranslator>";
    }

    private void addIsShowAllInlineMedia(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isShowAllInlineMedia>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isShowAllInlineMedia();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isShowAllInlineMedia>";
    }

    private void addIsProtected(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isProtected>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isProtected();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isProtected>";
    }

    private void addIsProfileBackgroundTiled(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isProfileBackgroundTiled>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isProfileBackgroundTiled();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isProfileBackgroundTiled>";
    }

    private void addIsProfileUseBackgroundImage(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isProfileBackgroundImage>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isProfileUseBackgroundImage();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isProfileBackgroundImage>";
    }

    private void addIsGeoEnabled(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isGeoEnabled>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isGeoEnabled();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isGeoEnabled>";
    }

    private void addIsFollowRequestSent(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isFollowRequestSent>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isFollowRequestSent();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isFollowRequestSent>";
    }

    private void addIsContributorsEnabled(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<isContributorsEnabled>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.isContributorsEnabled();
        this.userXMLString = String.valueOf(this.userXMLString) + "</isContributorsEnabled>";
    }

    private void addUtcOffset(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<UtcOffset>";
        this.userXMLString = String.valueOf(this.userXMLString) + Integer.toString(u.getUtcOffset());
        this.userXMLString = String.valueOf(this.userXMLString) + "</UtcOffset>";
    }

    private void addUserURL(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<userURL>";
        String url = u.getURL();
        this.userXMLString = String.valueOf(this.userXMLString) + url.toString();
        this.userXMLString = String.valueOf(this.userXMLString) + "</userURL>";
    }

    private void addTimeZone(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<timeZone>";
        if (u.getTimeZone() != null) {
            this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getTimeZone());
        }
        this.userXMLString = String.valueOf(this.userXMLString) + "</timeZone>";
    }

    private void addStatusCount(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<statusCount>";
        this.userXMLString = String.valueOf(this.userXMLString) + Integer.toString(u.getStatusesCount());
        this.userXMLString = String.valueOf(this.userXMLString) + "</statusCount>";
    }

    private void addCurrentStatus(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<currentStatus>";
        if (u.getStatus() != null) {
            this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getStatus().getText());
        }
        this.userXMLString = String.valueOf(this.userXMLString) + "</currentStatus>";
    }

    private void addProfileTextColor(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<profileTextColor>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getProfileTextColor();
        this.userXMLString = String.valueOf(this.userXMLString) + "</profileTextColor>";
    }

    private void addScreenName(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<screenName>";
        this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getScreenName());
        this.userXMLString = String.valueOf(this.userXMLString) + "</screenName>";
        this.screenName = u.getScreenName();
    }

    private void addProfileSidebarFillColor(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<profileSidebarFillColor>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getProfileSidebarFillColor();
        this.userXMLString = String.valueOf(this.userXMLString) + "</profileSidebarFillColor>";
    }

    private void addProfileLinkColor(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<profileLinkColor>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getProfileLinkColor();
        this.userXMLString = String.valueOf(this.userXMLString) + "</profileLinkColor>";
    }

    private void addProfileSidebarBorderColor(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<profileSidebarBorderColor>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getProfileSidebarBorderColor();
        this.userXMLString = String.valueOf(this.userXMLString) + "</profileSidebarBorderColor>";
    }

    private void addProfileImageURL(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<profileImageURL>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getProfileImageURL().toString();
        this.userXMLString = String.valueOf(this.userXMLString) + "</profileImageURL>";
    }

    private void addProfileBackgroundColor(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<profileBackgroundColor>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getProfileBackgroundColor();
        this.userXMLString = String.valueOf(this.userXMLString) + "</profileBackgroundColor>";
    }

    private void addName(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<Name>";
        this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getName());
        this.userXMLString = String.valueOf(this.userXMLString) + "</Name>";
        this.userName = u.getName();
    }

    private void addUserLocation(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<userLocation>";
        if (u.getLocation() != null) {
            this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getLocation());
        }
        this.userXMLString = String.valueOf(this.userXMLString) + "</userLocation>";
    }

    private void addListedCount(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<listedCount>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getListedCount();
        this.userXMLString = String.valueOf(this.userXMLString) + "</listedCount>";
    }

    private void addUserId(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<userID>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getId();
        this.userXMLString = String.valueOf(this.userXMLString) + "</userID>";
        this.userId = "" + u.getId();
    }

    private void addPreferredLanguage(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<preferredLanguage>";
        this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getLang());
        this.userXMLString = String.valueOf(this.userXMLString) + "</preferredLanguage>";
    }

    private void addFriendsCount(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<friendsCount>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getFriendsCount();
        this.userXMLString = String.valueOf(this.userXMLString) + "</friendsCount>";
    }

    private void addFollowersCount(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<followersCount>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getFollowersCount();
        this.userXMLString = String.valueOf(this.userXMLString) + "</followersCount>";
    }

    private void addDescription(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<description>";
        if (u.getDescription() != null) {
            this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getDescription());
        }
        this.userXMLString = String.valueOf(this.userXMLString) + "</description>";
    }

    private void addFavouritesCount(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<favouritesCount>";
        this.userXMLString = String.valueOf(this.userXMLString) + u.getFavouritesCount();
        this.userXMLString = String.valueOf(this.userXMLString) + "</favouritesCount>";
    }

    private void addCreatedAt(User u) {
        this.userXMLString = String.valueOf(this.userXMLString) + "<createdAt>";
        this.userXMLString = String.valueOf(this.userXMLString) + this.processor.forXML(u.getCreatedAt().toString());
        this.userXMLString = String.valueOf(this.userXMLString) + "</createdAt>";
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getScreenName() {
        return this.screenName;
    }
}

