/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.twitterv2.utils;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TwitterInfoResponseParser {
    private static final Logger log = Logger.getLogger(TwitterInfoResponseParser.class.getName());

    static {
        log.setLevel(Level.ALL);
    }

    public Map<String, String> parse(String xml) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputSource source = new InputSource();
            source.setCharacterStream(new StringReader(xml));
            Document doc = null;
            try {
                doc = builder.parse(source);
            }
            catch (Throwable throwable) {
                log.info("Error Parsing: " + xml);
            }
            NodeList rootNode = doc.getElementsByTagName("Status");
            rootNode = rootNode.item(0).getChildNodes();
            int i = 0;
            while (i < rootNode.getLength()) {
                Element element = (Element)rootNode.item(i);
                if (element.getTagName() == "user") {
                    String tagName = String.valueOf(element.getTagName()) + ".";
                    NodeList userNode = element.getChildNodes();
                    int j = 0;
                    while (j < userNode.getLength()) {
                        Element userElement = (Element)userNode.item(j);
                        String tag = String.valueOf(tagName) + userElement.getTagName();
                        String value = userElement.getTextContent();
                        propertiesMap.put("twitter." + tag, value);
                        ++j;
                    }
                } else {
                    String tag = element.getTagName();
                    String value = element.getTextContent();
                    propertiesMap.put(tag, value);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return propertiesMap;
    }
}

