/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.twitterv2.utils;

import ie.ucd.sixth.adaptor.twitterv2.utils.StringProcessor;
import ie.ucd.sixth.adaptor.twitterv2.utils.UserToXMLConverter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.Place;
import twitter4j.Scopes;
import twitter4j.Status;
import twitter4j.URLEntity;
import twitter4j.UserMentionEntity;

public class StatusToXMLConverter {
    private String xmlStatusString = "";
    private List<Status> statusList;
    private String userId = "";
    private StringProcessor processor;
    private String userName;
    private String screenName;
    private String inReplyToScreenName;
    private long inReplyToUserId;
    private HashMap<Long, String> mentionsMap;

    public StatusToXMLConverter() {
        this.processor = new StringProcessor();
    }

    public StatusToXMLConverter(List<Status> statusList) {
        this.statusList = statusList;
        this.processor = new StringProcessor();
    }

    public String convertStatusList() {
        String result = "<StatusResults>";
        for (Status s : this.statusList) {
            result = String.valueOf(result) + this.convertStatus(s);
        }
        result = String.valueOf(result) + "</StatusResults>";
        return result;
    }

    public String convertStatus(Status s) {
        this.xmlStatusString = "";
        this.addContributors(s);
        this.addCreatedAt(s);
        this.addCurrentUserRetweetId(s);
        this.addgeoLocation(s);
        this.addStatusID(s);
        this.addInReplyToScreenName(s);
        this.addInReplyToStatusId(s);
        this.addInReplyToUserID(s);
        this.addLanguage(s);
        this.addPlace(s);
        this.addRetweetCount(s);
        this.addScopes(s);
        this.addSource(s);
        this.addText(s);
        this.addUser(s);
        this.addIsFavourited(s);
        this.addIsPossiblySensitive(s);
        return this.xmlStatusString;
    }

    private void addIsRetweeted(Status s) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<isRetweeted>";
        boolean isRetweeted = s.isRetweeted();
        this.xmlStatusString = isRetweeted ? String.valueOf(this.xmlStatusString) + "true" : String.valueOf(this.xmlStatusString) + "false";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</isRetweeted>";
    }

    private void addIsPossiblySensitive(Status s) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<isPossiblySensitive>";
        boolean sensitive = s.isPossiblySensitive();
        this.xmlStatusString = sensitive ? String.valueOf(this.xmlStatusString) + true : String.valueOf(this.xmlStatusString) + false;
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</isPossiblySensitive>";
    }

    private void addScopes(Status s) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<scopes>";
        Scopes scopes = s.getScopes();
        if (scopes != null) {
            String[] places;
            String[] stringArray = places = scopes.getPlaceIds();
            int n = places.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<placeId>" + string + "</placeId>";
                ++n2;
            }
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</scopes>";
    }

    private void addLanguage(Status s) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<language>";
        String language = s.getLang();
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + language;
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</language>";
    }

    private void addFavouriteCount(Status s) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<favouriteCount>";
        int count = s.getFavoriteCount();
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + count;
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</favouriteCount>";
    }

    private void addCurrentUserRetweetId(Status s) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<currentUserRetweetId>";
        long id = s.getCurrentUserRetweetId();
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + id;
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</currentUserRetweetId>";
    }

    private void addCreatedAt(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<createdAt>";
        Date date = status.getCreatedAt();
        if (date != null) {
            String dateString = date.toString();
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + dateString;
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</createdAt>";
    }

    private void addContributors(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<contributors>";
        long[] conts = status.getContributors();
        if (conts != null) {
            int i = 0;
            while (i < conts.length) {
                this.xmlStatusString = String.valueOf(this.xmlStatusString) + conts[i] + "'";
                ++i;
            }
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</contributors>";
    }

    private void addgeoLocation(Status status) {
        GeoLocation geolocation = status.getGeoLocation();
        if (geolocation != null) {
            double latitude = geolocation.getLatitude();
            double longitude = geolocation.getLongitude();
            String coordsString = "<latitude>" + latitude + "</latitude><longitude>" + longitude + "</longitude>";
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + coordsString;
        }
    }

    private void addHashTagEntities(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<hashTagEntities>";
        HashtagEntity[] tags = status.getHashtagEntities();
        int i = 0;
        while (i < tags.length) {
            String tag = tags[i].getText();
            tag = this.processor.forXML(tag);
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + tag + ",";
            ++i;
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</hashTagEntities>";
    }

    private void addStatusID(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<statusID>";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + status.getId();
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</statusID>";
    }

    private void addInReplyToScreenName(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<inReplyToScreenName>";
        if (status.getInReplyToScreenName() != null) {
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + this.processor.forXML(status.getInReplyToScreenName());
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</inReplyToScreenName>";
        this.inReplyToScreenName = status.getInReplyToScreenName();
        this.inReplyToUserId = status.getInReplyToUserId();
    }

    private void addInReplyToStatusId(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<inReplyToStatusID>";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + Long.toString(status.getInReplyToStatusId());
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</inReplyToStatusID>";
    }

    private void addInReplyToUserID(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<inReplyToUserID>";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + Long.toString(status.getInReplyToUserId());
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</inReplyToUserID>";
    }

    private void addPlace(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<place>";
        Place place = status.getPlace();
        if (place != null) {
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + this.processor.forXML(place.getCountry());
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</place>";
    }

    private void addRetweetCount(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<retweetCount>";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + Long.toString(status.getRetweetCount());
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</retweetCount>";
    }

    private void addSource(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<source>";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + status.getSource();
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</source>";
    }

    private void addText(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<text>";
        try {
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + this.processor.forXML(status.getText());
        }
        catch (Exception exception) {}
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</text>";
    }

    private void addURLEntities(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<URLEntities>";
        URLEntity[] urls = status.getURLEntities();
        int i = 0;
        while (i < urls.length) {
            this.xmlStatusString = String.valueOf(this.xmlStatusString) + urls[i].toString() + ",";
            ++i;
        }
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</URLEntities>";
    }

    private void addUser(Status status) {
        UserToXMLConverter conv = new UserToXMLConverter();
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + conv.convertUser(status.getUser());
        this.userId = conv.getUserId();
        this.userName = conv.getUserName();
        this.screenName = conv.getScreenName();
    }

    private void addUserMentionEntities(Status status) {
        UserMentionEntity[] mentions = status.getUserMentionEntities();
        this.mentionsMap = new HashMap();
        int i = 0;
        while (i < mentions.length) {
            String screenName = mentions[i].getScreenName();
            long id = mentions[i].getId();
            this.mentionsMap.put(id, screenName);
            ++i;
        }
    }

    private void addIsFavourited(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<isFavourited>";
        this.xmlStatusString = status.isFavorited() ? String.valueOf(this.xmlStatusString) + "true" : String.valueOf(this.xmlStatusString) + "false";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</isFavourited>";
    }

    private void addIsRetweet(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<isRetweet>";
        this.xmlStatusString = status.isRetweet() ? String.valueOf(this.xmlStatusString) + "true" : String.valueOf(this.xmlStatusString) + "false";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</isRetweet>";
    }

    private void addIsRetweetedByMe(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<isRetweetedByME>";
        this.xmlStatusString = status.isRetweetedByMe() ? String.valueOf(this.xmlStatusString) + "true" : String.valueOf(this.xmlStatusString) + "false";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</isRetweetedByME>";
    }

    private void addIsTruncated(Status status) {
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "<isTruncated>";
        this.xmlStatusString = status.isTruncated() ? String.valueOf(this.xmlStatusString) + "true" : String.valueOf(this.xmlStatusString) + "false";
        this.xmlStatusString = String.valueOf(this.xmlStatusString) + "</isTruncated>";
    }

    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public HashMap<Long, String> getMentions() {
        return this.mentionsMap;
    }
}

