/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.twitterv2;

import ie.ucd.sixth.adaptor.twitterv2.ResourceManager;
import ie.ucd.sixth.adaptor.twitterv2.utils.StatusToXMLConverter;
import ie.ucd.sixth.adaptor.twitterv2.utils.TwitterInfoResponseParser;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractAdaptorStream;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractCyberAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AggregateProperty;
import ie.ucd.sixth.core.cyber.adaptor.sensor.CyberSensorData;
import ie.ucd.sixth.core.cyber.sensor.CyberSensor;
import ie.ucd.sixth.core.cyber.utils.parsers.XmlToMapConverter;
import ie.ucd.sixth.core.utils.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import twitter4j.FilterQuery;
import twitter4j.GeoLocation;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.StreamListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.User;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterStreamAdaptor
extends AbstractAdaptorStream {
    private final int numStatus = 0;
    private String[] filterTerms;
    private long[] userIDs;
    private double[][] filterLocations;
    private TwitterStream twitterStream;
    private StatusToXMLConverter converter = new StatusToXMLConverter();
    private TwitterInfoResponseParser responseParser = new TwitterInfoResponseParser();
    private boolean notdone = true;
    protected long lastCallTimeMilis = 0L;
    protected static final long requiredMilisBetweenCalls = 20000L;

    public TwitterStreamAdaptor(AbstractCyberAdaptor adaptor) {
        super(adaptor);
    }

    public void stream() {
        int i;
        Set values;
        AggregateProperty keywords;
        this.lastCallTimeMilis = System.currentTimeMillis();
        this.active = true;
        if (!this.aggregateProperties.isEmpty()) {
            this.active = false;
        }
        if (this.aggregateProperties.containsKey("keyword")) {
            keywords = (AggregateProperty)this.aggregateProperties.get("keyword");
            values = keywords.getValues();
            this.filterTerms = values.toArray(new String[values.size()]);
        }
        if (this.aggregateProperties.containsKey("userid")) {
            AggregateProperty userids = (AggregateProperty)this.aggregateProperties.get("userid");
            values = userids.getValues();
            this.userIDs = new long[values.size()];
            i = 0;
            for (String idString : values) {
                try {
                    this.userIDs[i] = Long.parseLong(idString);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.aggregateProperties.containsKey("boundingbox")) {
            keywords = (AggregateProperty)this.aggregateProperties.get("boundingbox");
            values = keywords.getValues();
            this.filterLocations = new double[values.size() * 2][values.size() * 2];
            i = 0;
            for (String string : values) {
                String[] bbArrS;
                if (string != null && !string.isEmpty() && !string.equalsIgnoreCase(" ") && (bbArrS = string.split(",")).length == 4) {
                    double[][] bbArrD = new double[bbArrS.length][bbArrS.length];
                    bbArrD[0][0] = Double.parseDouble(bbArrS[0]);
                    bbArrD[0][1] = Double.parseDouble(bbArrS[1]);
                    bbArrD[1][0] = Double.parseDouble(bbArrS[2]);
                    bbArrD[1][1] = Double.parseDouble(bbArrS[3]);
                    this.filterLocations[i][0] = bbArrD[1][0];
                    this.filterLocations[i][1] = bbArrD[0][0];
                    this.filterLocations[i + 1][0] = bbArrD[1][1];
                    this.filterLocations[i + 1][1] = bbArrD[0][1];
                    i += 2;
                }
                this.filterLocations[0][0] = -180.0;
                this.filterLocations[0][1] = -90.0;
                this.filterLocations[1][0] = 180.0;
                this.filterLocations[1][1] = 90.0;
            }
        }
        StatusListener statusListener = new StatusListener(){

            public void onException(Exception arg0) {
            }

            public void onTrackLimitationNotice(int arg0) {
            }

            public void onStatus(Status status) {
                System.out.println("Received status " + status.getGeoLocation() + " #" + status.getUser().getLocation() + "#");
                TwitterStreamAdaptor.this.pushDataToSensors(status);
            }

            public void onScrubGeo(long arg0, long arg1) {
            }

            public void onDeletionNotice(StatusDeletionNotice arg0) {
            }

            public void onStallWarning(StallWarning arg0) {
            }
        };
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(true).setOAuthConsumerKey("cViOg4u0WnEsMOeQKPN0PuV0f").setOAuthConsumerSecret("22wYfaQMWmOCzdMl1Rvg6hlZPSPtCBhdXDrF575BKOcvEHGG4b").setOAuthAccessToken("135646722-Rsu7OEQQRF3E4t3XqeeLSnUODCEKqTo6NYgahXOS").setOAuthAccessTokenSecret("dTps8iW8hBfqGexcSxcDNJvk3NCz1jVd94WMWb0vdoiOl");
        TwitterStream twitterStream = new TwitterStreamFactory(cb.build()).getInstance();
        twitterStream.addListener((StreamListener)statusListener);
        System.out.println("Filter Query");
        if (this.userIDs != null) {
            System.out.println("userIDs " + this.userIDs.length);
            long[] lArray = this.userIDs;
            int n = this.userIDs.length;
            int n2 = 0;
            while (n2 < n) {
                long l = lArray[n2];
                System.out.println(l);
                ++n2;
            }
        }
        System.out.println("filterTerms " + this.filterTerms.length);
        Object object = this.filterTerms;
        int n = this.filterTerms.length;
        int n3 = 0;
        while (n3 < n) {
            String s = object[n3];
            System.out.println(s);
            ++n3;
        }
        if (this.filterLocations != null) {
            System.out.println("filterLocations " + this.filterLocations.length);
            object = this.filterLocations;
            n = this.filterLocations.length;
            n3 = 0;
            while (n3 < n) {
                String d = object[n3];
                System.out.println("dl " + ((String)d).length);
                String string = d;
                int n4 = ((String)string).length;
                int n5 = 0;
                while (n5 < n4) {
                    String dd = string[n5];
                    System.out.print(String.valueOf((double)dd) + " ");
                    ++n5;
                }
                System.out.println();
                ++n3;
            }
        }
        FilterQuery query = new FilterQuery(0, this.userIDs, this.filterTerms, this.filterLocations);
        twitterStream.filter(query);
    }

    public void shutdown() {
        if (this.active) {
            this.twitterStream.shutdown();
            this.active = false;
        }
    }

    public void start() {
        if (this.active && this.twitterStream != null) {
            this.shutdown();
        }
        this.stream();
    }

    public void pushDataToSensors(Status status) {
        User user;
        String xmlStatus = "<twitter>" + this.converter.convertStatus(status) + "</twitter>";
        XmlToMapConverter xmlConv = new XmlToMapConverter();
        Map datamap = xmlConv.parse(xmlStatus);
        datamap.keySet();
        GeoLocation location = status.getGeoLocation();
        Double latitude = null;
        Double longitude = null;
        if (location != null) {
            location.toString().toLowerCase();
            latitude = location.getLatitude();
            longitude = location.getLongitude();
        }
        if (latitude != null && longitude != null) {
            for (Integer integer : this.sensorMap.keySet()) {
                CyberSensor locationSensor;
                CyberSensor cfr_ignored_0 = (CyberSensor)this.sensorMap.get(integer);
                if (!((CyberSensor)this.sensorMap.get(integer)).getSensorType().equalsIgnoreCase("location") || !(locationSensor = (CyberSensor)this.sensorMap.get(integer)).checkBoundingBox(latitude, longitude)) continue;
                CyberSensorData data = new CyberSensorData(locationSensor.getNetwork(), locationSensor.getID(), String.valueOf(locationSensor.getSensorType()) + ":" + locationSensor.getSensedModality(), datamap, "periodic", System.currentTimeMillis(), this.adaptor.getDataModel());
                this.pushDataToSensor(locationSensor, data);
            }
        }
        if ((user = status.getUser()) != null) {
            user.getLocation().toLowerCase();
        }
        String tweetText = status.getText().toLowerCase();
        Set keywordValues = this.getValuesForProperty("keyword");
        if (keywordValues != null && !keywordValues.isEmpty()) {
            for (String keywordValue : keywordValues) {
                if (!tweetText.contains(keywordValue.toLowerCase())) continue;
                List sensors = this.getSensorsForValue("keyword", keywordValue);
                for (Integer sensorID : sensors) {
                    CyberSensor sensor = (CyberSensor)this.sensorMap.get(sensorID);
                    CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), datamap, "periodic", System.currentTimeMillis(), this.adaptor.getDataModel());
                    this.pushDataToSensor(sensor, data);
                }
            }
        }
        long userID = status.getUser().getId();
        Set userValues = this.getValuesForProperty("userid");
        if (userValues != null && !userValues.isEmpty()) {
            for (String userValue : userValues) {
                if (!userValue.equalsIgnoreCase(String.valueOf(userID))) continue;
                List sensors = this.getSensorsForValue("userid", userValue);
                for (Integer sensorID : sensors) {
                    CyberSensor sensor = (CyberSensor)this.sensorMap.get(sensorID);
                    CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), datamap, "periodic", System.currentTimeMillis(), this.adaptor.getDataModel());
                    this.pushDataToSensor(sensor, data);
                }
            }
        }
    }

    protected void queueStart(CyberSensor sensor) {
        final CyberSensor mySensor = sensor;
        final TwitterStreamAdaptor myadaptor = this;
        long nowTime = System.currentTimeMillis();
        long difference = nowTime - this.lastCallTimeMilis;
        if (difference < 20000L) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String username;
                    HashMap props = mySensor.getSetPropertiesMap();
                    if (mySensor.getSensorType().equalsIgnoreCase("location")) {
                        if (props.containsKey("latlong")) {
                            String[] arr;
                            String latlon = ((Property)props.get("latlong")).getContent();
                            logger.info("about to try searching by location using latlong to save restarting the stream adaptor... " + latlon);
                            if (latlon != null && !latlon.isEmpty() && (arr = latlon.split(",")).length == 2) {
                                try {
                                    double lat = Double.parseDouble(arr[0]);
                                    double lon = Double.parseDouble(arr[1]);
                                    ResourceManager.searchByLocation(lat, lon, myadaptor);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        }
                    } else if (mySensor.getSensorType().equalsIgnoreCase("entity")) {
                        String keyword;
                        if (props.containsKey("keyword") && (keyword = ((Property)props.get("keyword")).getContent()) != null && !keyword.isEmpty()) {
                            ResourceManager.searchByKeyword(keyword, myadaptor);
                        }
                    } else if (mySensor.getSensorType().equalsIgnoreCase("user") && props.containsKey("username") && (username = ((Property)props.get("username")).getContent()) != null && !username.isEmpty()) {
                        ResourceManager.searchByUser(username, myadaptor);
                    }
                }
            }).start();
        } else {
            this.start();
        }
    }
}

