/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.shoothill;

import ie.ucd.sixth.core.cyber.utils.UrlRequester;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class ShoothillService {
    public void getFloodAlerts() {
        String FLOOD_API_KEY = "a837b757-7b19-4d41-8e1b-c203c2e46bf4";
        String authURL = "https://apifa.shoothill.com/Account/APILogin";
        String floodURL = "https://apifa.shoothill.com/API/Floods";
        UrlRequester requester = new UrlRequester();
        LinkedHashMap<String, Object> postData = new LinkedHashMap<String, Object>();
        postData.put("apikey", FLOOD_API_KEY);
        postData.put("persist", "1");
        String authCookie = ".ASPXAUTH=" + this.post(authURL, postData);
        LinkedHashMap<String, String> authMap = new LinkedHashMap<String, String>();
        authMap.put("Cookie", authCookie);
        authMap.put("Content-Type", "application/json");
        String response = requester.makeRequest(floodURL, authMap);
        System.out.println("response: " + response);
    }

    public void getRiverLevels() {
        String RIVER_API_KEY = "8000f20a-9409-4eb2-88e2-79b81aac6078";
        String authURL = "http://riverlevelsapi.shoothill.com/ApiAccount/APILogin";
        String riverURL = "http://riverlevelsapi.shoothill.com/TimeSeries/GetTimeSeriesStations?dataTypes=3";
        UrlRequester requester = new UrlRequester();
        LinkedHashMap<String, Object> postData = new LinkedHashMap<String, Object>();
        postData.put("apikey", RIVER_API_KEY);
        postData.put("persist", "1");
        String authCookie = ".ASPXAUTH=" + this.post(authURL, postData);
        LinkedHashMap<String, String> authMap = new LinkedHashMap<String, String>();
        authMap.put("Cookie", authCookie);
        authMap.put("Content-Type", "application/json");
        String response = requester.makeRequest(riverURL, authMap);
        System.out.println("response: " + response);
    }

    public void getThreeDayFloodForecast() {
        String RIVER_API_KEY = "8000f20a-9409-4eb2-88e2-79b81aac6078";
        String authURL = "http://riverlevelsapi.shoothill.com/ApiAccount/APILogin";
        String riverURL = "http://riverlevelsapi.shoothill.com/ThreeDayFloodForecast/GetCurrentForecast";
        UrlRequester requester = new UrlRequester();
        LinkedHashMap<String, Object> postData = new LinkedHashMap<String, Object>();
        postData.put("apikey", RIVER_API_KEY);
        postData.put("persist", "1");
        String authCookie = ".ASPXAUTH=" + this.post(authURL, postData);
        LinkedHashMap<String, String> authMap = new LinkedHashMap<String, String>();
        authMap.put("Cookie", authCookie);
        authMap.put("Content-Type", "application/json");
        String response = requester.makeRequest(riverURL, authMap);
        System.out.println("response: " + response);
    }

    public static void main(String[] args) throws Exception {
        ShoothillService test = new ShoothillService();
        test.getFloodAlerts();
    }

    public String post(String request, Map<String, Object> params) {
        try {
            URL url = new URL(request);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postDataBytes);
            String authhead = conn.getHeaderField("Set-Cookie");
            System.out.println("authhead: " + authhead);
            String[] apiAuthTicket = authhead.split("=");
            String authCookie = apiAuthTicket[1].split(";")[0];
            System.out.println("cookiee: " + authCookie);
            return authCookie;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

