/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.shoothill;

import ie.ucd.sixth.core.cyber.utils.parsers.XmlToMapConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShoothillFloodService {
    public static void main(String[] args) throws Exception {
        ShoothillFloodService test = new ShoothillFloodService();
        Map<String, String> dataMap = test.getwfsFloodAlerts();
        for (String string : dataMap.keySet()) {
            System.out.println("key: " + string + ", " + dataMap.get(string));
        }
        test.getSepaFloodAlerts();
        for (String string : dataMap.keySet()) {
            System.out.println("key2: " + string + ", " + dataMap.get(string));
        }
    }

    public Map<Integer, Map<String, String>> getIndividualDataMaps() {
        HashMap<Integer, Map<String, String>> dataList = new HashMap<Integer, Map<String, String>>();
        Map<String, String> dataMap = this.getwfsFloodAlerts();
        int i = 0;
        for (String string : dataMap.keySet()) {
            HashMap<String, String> map;
            String value = dataMap.get(string);
            if (string.contains("." + i + ".")) {
                string = string.replace("." + i + ".", ".");
                if (!dataList.containsKey(i)) {
                    map = new HashMap<String, String>();
                    map.put(string, value);
                    dataList.put(i, map);
                    continue;
                }
                ((Map)dataList.get(i)).put(string, value);
                continue;
            }
            if (!string.contains("." + ++i + ".")) continue;
            string = string.replace("." + i + ".", ".");
            if (!dataList.containsKey(i)) {
                map = new HashMap();
                map.put(string, value);
                dataList.put(i, map);
                continue;
            }
            ((Map)dataList.get(i)).put(string, value);
        }
        return dataList;
    }

    public Map<String, String> getwfsFloodAlerts() {
        String FLOOD_API_KEY = "a837b757-7b19-4d41-8e1b-c203c2e46bf4";
        String authURL = "https://apifa.shoothill.com/Account/APILogin";
        String floodURL = "https://apifa.shoothill.com/API/Floods";
        LinkedHashMap<String, Object> postData = new LinkedHashMap<String, Object>();
        postData.put("apikey", FLOOD_API_KEY);
        postData.put("persist", "1");
        String authCookie = ".ASPXAUTH=" + this.post(authURL, postData);
        LinkedHashMap<String, String> authMap = new LinkedHashMap<String, String>();
        authMap.put("Cookie", authCookie);
        authMap.put("Content-Type", "application/json");
        String response = this.get(floodURL, authMap);
        Map dataMap = new XmlToMapConverter().parse(response);
        return dataMap;
    }

    public Map<String, String> getSepaFloodAlerts() {
        String FLOOD_API_KEY = "a837b757-7b19-4d41-8e1b-c203c2e46bf4";
        String authURL = "https://apifa.shoothill.com/Account/APILogin";
        String floodURL = "https://apifa.shoothill.com/API/SepaFloods";
        LinkedHashMap<String, Object> postData = new LinkedHashMap<String, Object>();
        postData.put("apikey", FLOOD_API_KEY);
        postData.put("persist", "1");
        String authCookie = ".ASPXAUTH=" + this.post(authURL, postData);
        LinkedHashMap<String, String> authMap = new LinkedHashMap<String, String>();
        authMap.put("Cookie", authCookie);
        authMap.put("Content-Type", "application/json");
        String response = this.get(floodURL, authMap);
        Map dataMap = new XmlToMapConverter().parse(response);
        return dataMap;
    }

    public String post(String request, Map<String, Object> params) {
        try {
            URL url = new URL(request);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postDataBytes);
            String authhead = conn.getHeaderField("Set-Cookie");
            conn.getHeaderFields();
            String[] apiAuthTicket = authhead.split("=");
            String authCookie = apiAuthTicket[1].split(";")[0];
            return authCookie;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String get(String urlRequestString, Map<String, String> requestParams) {
        String response = "";
        urlRequestString = ShoothillFloodService.urlEncodeString(urlRequestString);
        try {
            URL url = new URL(urlRequestString);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoInput(true);
            if (requestParams != null && !requestParams.isEmpty()) {
                for (String param : requestParams.keySet()) {
                    urlConnection.setRequestProperty(param, requestParams.get(param));
                }
            }
            InputStream inStream = urlConnection.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(inStream));
            Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
            for (String string : headerFields.keySet()) {
                Iterator<String> iterator = headerFields.get(string).iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            String output = "";
            while ((output = input.readLine()) != null) {
                response = String.valueOf(response) + output;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.out.println(urlRequestString);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(urlRequestString);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(urlRequestString);
            return null;
        }
        return response;
    }

    private static String urlEncodeString(String string) {
        return string.replace(" ", "&20");
    }
}

