/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.adaptor.worldweather;

import ie.ucd.sixth.adaptor.worldweather.ResourceManager;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractAdaptorStream;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AbstractCyberAdaptor;
import ie.ucd.sixth.core.cyber.adaptor.sensor.AggregateProperty;
import ie.ucd.sixth.core.cyber.adaptor.sensor.CyberSensorData;
import ie.ucd.sixth.core.cyber.sensor.CyberSensor;
import ie.ucd.sixth.core.cyber.sensor.EntityCyberSensor;
import ie.ucd.sixth.core.cyber.sensor.LocationCyberSensor;
import ie.ucd.sixth.core.cyber.utils.geocode.WorldCoordinates;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorldWeatherResourceManager
extends AbstractAdaptorStream
implements Runnable {
    private ResourceManager resourceManager = new ResourceManager();
    private int frequencySeconds = 30;
    private boolean threadStopped;

    public WorldWeatherResourceManager(AbstractCyberAdaptor adaptor) {
        super(adaptor);
    }

    public void stream() {
        logger.info("in stream");
        if (this.active) {
            this.shutdown();
            logger.info("the stream was active so we shut it down");
        }
        if (!this.aggregateProperties.isEmpty()) {
            logger.info("aggregate properties map is not empty");
            this.threadStopped = false;
            logger.info("about to start thread");
            this.active = true;
            this.setFrequency();
            new Thread(this).start();
        } else {
            logger.info("AGGREGATE PROPERTIES MAP IS EMPTY");
        }
    }

    public synchronized void setFrequency() {
        this.frequencySeconds = 5;
    }

    public void shutdown() {
        if (this.active) {
            this.active = false;
        }
    }

    public void start() {
        if (this.active) {
            this.shutdown();
        }
        this.stream();
    }

    protected void queueStart(CyberSensor sensor) {
        this.start();
    }

    @Override
    public void run() {
        logger.info("starting weather stream...");
        WorldCoordinates world = new WorldCoordinates();
        final Map coordinates = world.getMap();
        this.active = true;
        if (this.aggregateProperties.isEmpty()) {
            this.active = false;
            System.out.println("no properties...");
        }
        logger.info("checking aggregate properties... ");
        for (String propertyname : this.aggregateProperties.keySet()) {
            logger.info("property name: " + propertyname + " values: " + ((AggregateProperty)this.aggregateProperties.get(propertyname)).getValues());
        }
        while (this.getFrequency() > 0) {
            AggregateProperty locationNames;
            Set values;
            this.threadStopped = false;
            if (this.aggregateProperties.containsKey("keyword")) {
                final AggregateProperty keywords = (AggregateProperty)this.aggregateProperties.get("keyword");
                values = keywords.getValues();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (String country : coordinates.keySet()) {
                            Double[] coords = (Double[])coordinates.get(country);
                            Map<String, String> weatherMap = ResourceManager.getWeatherForLocation("" + coords[0], "" + coords[1]);
                            logger.info("weather properties: " + weatherMap.keySet());
                            String weatherText = weatherMap.get("data.current_condition.weatherDesc.#cdata-section");
                            logger.info("found weathe description..... " + weatherText);
                            for (String string : values) {
                                string = string.toLowerCase();
                                weatherText = weatherText.toLowerCase();
                                logger.info("checking values.... ");
                                if (!weatherText.contains(string)) continue;
                                List sensors = keywords.getSensorsForValue(string);
                                for (Integer integer : sensors) {
                                    EntityCyberSensor sensor = (EntityCyberSensor)WorldWeatherResourceManager.this.sensorMap.get(integer);
                                    if (sensor == null) continue;
                                    CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), weatherMap, "periodic", System.currentTimeMillis(), WorldWeatherResourceManager.this.adaptor.getDataModel());
                                    WorldWeatherResourceManager.this.pushDataToSensor((CyberSensor)sensor, data);
                                }
                            }
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();
            }
            if (this.aggregateProperties.containsKey("locationname")) {
                logger.info("have location values.....");
                locationNames = (AggregateProperty)this.aggregateProperties.get("locationname");
                values = locationNames.getValues();
                logger.info("values: " + values);
                for (String string : values) {
                    Map<String, String> weatherMap = ResourceManager.getWeatherForLocation(string);
                    logger.info("have weather map... " + weatherMap.size());
                    List sensors = locationNames.getSensorsForValue(string);
                    logger.info("have sensors or are they null? " + (sensors == null));
                    for (Integer integer : sensors) {
                        logger.info("sensor: " + integer + ": " + (this.sensorMap.get(integer) == null));
                        LocationCyberSensor sensor = (LocationCyberSensor)this.sensorMap.get(integer);
                        if (sensor == null) continue;
                        CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), weatherMap, "periodic", System.currentTimeMillis(), this.adaptor.getDataModel());
                        logger.info("created data object");
                        this.pushDataToSensor((CyberSensor)sensor, data);
                        logger.info("data has been sent to sensor");
                    }
                }
            }
            if (this.aggregateProperties.containsKey("latlong")) {
                logger.info("have location values.....");
                locationNames = (AggregateProperty)this.aggregateProperties.get("latlong");
                values = locationNames.getValues();
                logger.info("values: " + values);
                for (String string : values) {
                    String[] coords = string.split(",");
                    Map<String, String> weatherMap = ResourceManager.getWeatherForLocation(coords[0], coords[1]);
                    logger.info("have weather map... " + weatherMap.size());
                    List sensors = locationNames.getSensorsForValue(string);
                    logger.info("have sensors or are they null? " + (sensors == null));
                    for (Integer integer : sensors) {
                        logger.info("sensor: " + integer + ": " + (this.sensorMap.get(integer) == null));
                        LocationCyberSensor sensor = (LocationCyberSensor)this.sensorMap.get(integer);
                        if (sensor == null) continue;
                        CyberSensorData data = new CyberSensorData(sensor.getNetwork(), sensor.getID(), String.valueOf(sensor.getSensorType()) + ":" + sensor.getSensedModality(), weatherMap, "periodic", System.currentTimeMillis(), this.adaptor.getDataModel());
                        logger.info("created data object");
                        this.pushDataToSensor((CyberSensor)sensor, data);
                        logger.info("data has been sent to sensor");
                    }
                }
            }
            try {
                Thread.sleep(this.getFrequency() * 3000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("frequency has changed...... " + this.getFrequency());
        this.threadStopped = true;
        this.active = false;
    }

    public synchronized int getFrequency() {
        return this.frequencySeconds;
    }

    static /* synthetic */ ResourceManager access$0(WorldWeatherResourceManager worldWeatherResourceManager) {
        return worldWeatherResourceManager.resourceManager;
    }
}

