/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.utils;

import ie.ucd.sixth.core.utils.Property;
import ie.ucd.sixth.core.utils.SensorSpecification;
import ie.ucd.sixth.core.utils.ServiceSpecification;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServiceSpecificationParser {
    private static final String commandNode = "adaptorDescription";

    public static ServiceSpecification parse(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        ServiceSpecification adaptor = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            Document doc = db.parse(is);
            Node node = doc.getFirstChild();
            node.getNodeName();
            NodeList elemList = doc.getElementsByTagName("service");
            Element adaptorElement = (Element)elemList.item(0);
            String adapName = adaptorElement.getAttribute("name");
            adaptor = new ServiceSpecification(adapName);
            ServiceSpecificationParser.getServices(adaptor, adaptorElement);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return adaptor;
    }

    private static void getServices(ServiceSpecification adaptor, Element adaptorElement) {
        Element sensorElement = adaptorElement;
        NamedNodeMap map = sensorElement.getAttributes();
        HashMap<String, String> stringMap = new HashMap<String, String>();
        int j = 0;
        while (j < map.getLength()) {
            Node node = map.item(j);
            String name = node.getNodeName();
            String type = node.getTextContent();
            stringMap.put(name, type);
            ++j;
        }
        SensorSpecification credentials = new SensorSpecification(stringMap);
        ServiceSpecificationParser.getProperties(sensorElement, map, credentials);
        adaptor.addService(credentials);
    }

    private static void getProperties(Element sensorElement, NamedNodeMap map, SensorSpecification credentials) {
        NodeList properties = sensorElement.getChildNodes();
        int j = 0;
        while (j < properties.getLength()) {
            Node item = properties.item(j);
            String textContent = item.getTextContent();
            NamedNodeMap map2 = item.getAttributes();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            int k = 0;
            while (k < map.getLength()) {
                Node node = map2.item(k);
                String name = node.getNodeName();
                String type = node.getTextContent();
                stringMap.put(name, type);
                ++k;
            }
            Property property = new Property(stringMap, textContent);
            credentials.add(property);
            ++j;
        }
    }

    public static void main(String[] args) {
        String serviceSpec = "<service name='TwitterUserGenerator' id='0000000'><property name='location' type='String' /><property name='keyword' type='String' /><property name='klout' type='Integer'/><property name='sensorStream' type='Boolean' /><property name='state' type='Boolean' /></service>";
        ServiceSpecificationParser.parse(serviceSpec);
    }
}

