/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.utils;

import ie.ucd.sixth.core.utils.ParseSensorProperties;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RetaskParser {
    private static Logger logger = Logger.getLogger(ParseSensorProperties.class.getName());
    private String sensor_service;
    private HashMap<String, String> propertiesMap;
    private boolean isConfigure;
    private boolean isCreate;
    private String sensorType;
    private String service;
    private String sensorId;
    private String pipeServiceType;
    private String pipeType;
    private String pipeServiceName;
    private boolean isCreatePipe;
    private boolean isConfigurePipe;
    private String pipeId;
    private String cyberServiceType;
    private String cyberServiceName;
    private boolean isCreateService;
    private String cyberServiceId;
    private boolean isConfigureService;

    static {
        logger.setLevel(Level.OFF);
    }

    public void parse(String xmlString) {
        this.isConfigure = false;
        this.isCreate = false;
        this.isCreatePipe = false;
        this.isConfigurePipe = false;
        this.propertiesMap = new HashMap();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            Document doc = db.parse(is);
            Node node = doc.getFirstChild();
            String command = node.getNodeName();
            if (command.equalsIgnoreCase("createSensor")) {
                NodeList nodelist = node.getChildNodes();
                Node sensorNode = nodelist.item(0);
                if (sensorNode.getTextContent().contains(".")) {
                    this.sensor_service = sensorNode.getTextContent();
                    String[] s = this.sensor_service.split(".");
                    this.sensorType = s[0];
                    this.service = s[1];
                } else {
                    this.sensorType = sensorNode.getTextContent();
                    Node serviceNode = nodelist.item(1);
                    this.service = serviceNode.getTextContent();
                }
                this.isCreate = true;
                logger.info("parseSensorProperties create sensor: " + this.sensorType);
            } else if (command.equalsIgnoreCase("createPipe")) {
                NodeList nodelist = node.getChildNodes();
                Node sensorNode = nodelist.item(0);
                if (sensorNode.getTextContent().contains(".")) {
                    this.sensor_service = sensorNode.getTextContent();
                    String[] s = this.sensor_service.split(".");
                    this.sensorType = s[0];
                    this.service = s[1];
                } else {
                    this.pipeServiceType = sensorNode.getTextContent();
                    Node typeNode = nodelist.item(1);
                    this.pipeType = typeNode.getTextContent();
                    Node nameNode = nodelist.item(2);
                    this.pipeServiceName = nameNode.getTextContent();
                }
                this.isCreatePipe = true;
                logger.info("parseSensorProperties create sensor: " + this.sensorType);
            } else if (command.equalsIgnoreCase("createService")) {
                NodeList nodelist = node.getChildNodes();
                Node sensorNode = nodelist.item(0);
                if (sensorNode.getTextContent().contains(".")) {
                    this.sensor_service = sensorNode.getTextContent();
                    String[] s = this.sensor_service.split(".");
                    this.sensorType = s[0];
                    this.service = s[1];
                } else {
                    this.cyberServiceType = sensorNode.getTextContent();
                    Node typeNode = nodelist.item(1);
                    this.cyberServiceName = typeNode.getTextContent();
                }
                this.isCreateService = true;
                logger.info("parseSensorProperties create sensor: " + this.sensorType);
            } else if (command.equalsIgnoreCase("configureService")) {
                this.isConfigureService = true;
                Element rootElement = doc.getDocumentElement();
                logger.info("root element: " + rootElement.getNodeName());
                NodeList elemList = doc.getElementsByTagName("service");
                if (elemList != null && elemList.getLength() > 0) {
                    Element serviceElement = (Element)elemList.item(0);
                    logger.info("serviceElement: " + serviceElement.getNodeName());
                    this.cyberServiceType = serviceElement.getAttribute("type");
                    this.cyberServiceId = serviceElement.getAttribute("id");
                    NodeList propertyList = serviceElement.getElementsByTagName("property");
                    if (propertyList != null && propertyList.getLength() > 0) {
                        int k = 0;
                        while (k < propertyList.getLength()) {
                            Element propertyElement = (Element)propertyList.item(k);
                            String propertyName = propertyElement.getAttribute("name");
                            String propertyValue = propertyElement.getTextContent();
                            logger.info("propertyName: " + propertyName + " property value: " + propertyValue);
                            this.addProperty(this.cyberServiceType, propertyName, propertyValue);
                            ++k;
                        }
                    }
                }
            } else if (command.equalsIgnoreCase("configureSensor")) {
                this.isConfigure = true;
                Element rootElement = doc.getDocumentElement();
                logger.info("root element: " + rootElement.getNodeName());
                NodeList elemList = doc.getElementsByTagName("sensor");
                if (elemList != null && elemList.getLength() > 0) {
                    Object propertyValue;
                    Element sensorElement = (Element)elemList.item(0);
                    logger.info("sensorElement: " + sensorElement.getNodeName());
                    this.sensorType = sensorElement.getAttribute("type");
                    logger.info("parseSensorProperties configure sensor: " + this.sensorType);
                    if (this.sensorType.contains(".")) {
                        String[] s = this.sensorType.split("\\.");
                        logger.info("setting sensor type and service: " + s.length);
                        propertyValue = s;
                        int propertyName = s.length;
                        int propertyElement = 0;
                        while (propertyElement < propertyName) {
                            String string = propertyValue[propertyElement];
                            logger.info("s: " + string);
                            ++propertyElement;
                        }
                        if (s.length >= 1) {
                            this.sensorType = s[0].trim();
                            this.service = s[1].trim();
                            logger.info("new sensorType and service: " + this.sensorType + ", " + this.service);
                        }
                    }
                    this.sensorId = sensorElement.getAttribute("id");
                    logger.info("sensor id in parser: " + this.sensorId);
                    NodeList propertyList = sensorElement.getElementsByTagName("property");
                    if (propertyList != null && propertyList.getLength() > 0) {
                        int k = 0;
                        while (k < propertyList.getLength()) {
                            Element propertyElement = (Element)propertyList.item(k);
                            String propertyName = propertyElement.getAttribute("name");
                            propertyValue = propertyElement.getTextContent();
                            logger.info("propertyName: " + propertyName + " property value: " + (String)propertyValue);
                            this.addProperty(this.sensorType, propertyName, (String)propertyValue);
                            ++k;
                        }
                    }
                }
            } else if (command.equalsIgnoreCase("configurePipe")) {
                this.isConfigurePipe = true;
                Element rootElement = doc.getDocumentElement();
                logger.info("root element: " + rootElement.getNodeName());
                NodeList elemList = doc.getElementsByTagName("service");
                if (elemList != null && elemList.getLength() > 0) {
                    Element serviceElement = (Element)elemList.item(0);
                    logger.info("serviceElement: " + serviceElement.getNodeName());
                    this.pipeServiceType = serviceElement.getAttribute("type");
                    logger.info("parseSensorProperties configure pipe: " + this.pipeServiceType);
                    this.pipeId = serviceElement.getAttribute("id");
                    logger.info("pipe id in parser: " + this.pipeId);
                    NodeList propertyList = serviceElement.getElementsByTagName("property");
                    if (propertyList != null && propertyList.getLength() > 0) {
                        int k = 0;
                        while (k < propertyList.getLength()) {
                            Element propertyElement = (Element)propertyList.item(k);
                            String propertyName = propertyElement.getAttribute("name");
                            String propertyValue = propertyElement.getTextContent();
                            logger.info("propertyName: " + propertyName + " property value: " + propertyValue);
                            this.addProperty(this.pipeServiceType, propertyName, propertyValue);
                            ++k;
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isConfigureService() {
        return this.isConfigureService;
    }

    public String getSensor_service() {
        return this.sensor_service;
    }

    public HashMap<String, String> getPropertiesMap() {
        return this.propertiesMap;
    }

    public boolean isCreatePipe() {
        return this.isCreatePipe;
    }

    public boolean isConfigurePipe() {
        return this.isConfigurePipe;
    }

    public String getCyberServiceType() {
        return this.cyberServiceType;
    }

    public String getCyberServiceName() {
        return this.cyberServiceName;
    }

    public boolean isCreateService() {
        return this.isCreateService;
    }

    public String getCyberServiceId() {
        return this.cyberServiceId;
    }

    public String getPipeId() {
        return this.pipeId;
    }

    public String getPipeServiceType() {
        return this.pipeServiceType;
    }

    public String getPipeType() {
        return this.pipeType;
    }

    public String getPipeServiceName() {
        return this.pipeServiceName;
    }

    public String getSensorType() {
        return this.sensorType.trim();
    }

    public String getService() {
        return this.service.trim();
    }

    public boolean isCreate() {
        return this.isCreate;
    }

    public boolean isConfigure() {
        return this.isConfigure;
    }

    public String getPropertyValue(String sensorType, String propertyName) {
        String value = this.propertiesMap.get(String.valueOf(sensorType) + "." + propertyName);
        logger.info("jmdns.cyber.parsesensorproperties... name: " + propertyName + " value: " + value);
        if (value != null) {
            return value;
        }
        return "";
    }

    private void addProperty(String sensorType, String propertyName, String propertyValue) {
        String key = String.valueOf(sensorType) + "." + propertyName;
        String value = propertyValue;
        this.propertiesMap.put(key, value);
    }

    public String getSensorId() {
        return this.sensorId;
    }
}

