/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.utils;

import ie.ucd.sixth.core.utils.AdaptorSpecification;
import ie.ucd.sixth.core.utils.Property;
import ie.ucd.sixth.core.utils.SensorSpecification;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AdaptorSpecificationParser {
    private static final Logger log = Logger.getLogger(AdaptorSpecificationParser.class.getName());
    private static final String commandNode = "adaptorDescription";

    static {
        log.setLevel(Level.SEVERE);
    }

    public static AdaptorSpecification parse(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        AdaptorSpecification adaptor = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            Document doc = db.parse(is);
            Node node = doc.getFirstChild();
            String command = node.getNodeName();
            log.info("command node: " + command);
            if (command.equalsIgnoreCase(commandNode)) {
                NodeList elemList = doc.getElementsByTagName(commandNode);
                Element adaptorElement = (Element)elemList.item(0);
                String adapName = adaptorElement.getAttribute("name");
                log.info("I was parsing " + xmlString);
                adaptor = new AdaptorSpecification(adapName);
                elemList = doc.getElementsByTagName("sensor");
                AdaptorSpecificationParser.getSensors(adaptor, elemList);
                elemList = doc.getElementsByTagName("pipe");
                AdaptorSpecificationParser.getPipes(adaptor, elemList);
                elemList = doc.getElementsByTagName("output");
                AdaptorSpecificationParser.getOutput(adaptor, elemList);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info(adaptor.toString());
        return adaptor;
    }

    private static void getSensors(AdaptorSpecification adaptor, NodeList elemList) {
        int i = 0;
        while (i < elemList.getLength()) {
            Element sensorElement = (Element)elemList.item(i);
            NamedNodeMap map = sensorElement.getAttributes();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            int j = 0;
            while (j < map.getLength()) {
                Node node = map.item(j);
                String name = node.getNodeName();
                String type = node.getTextContent();
                stringMap.put(name, type);
                ++j;
            }
            SensorSpecification credentials = new SensorSpecification(stringMap);
            AdaptorSpecificationParser.getProperties(sensorElement, map, credentials);
            adaptor.addSensor(credentials);
            ++i;
        }
    }

    private static void getPipes(AdaptorSpecification adaptor, NodeList elemList) {
        int i = 0;
        while (i < elemList.getLength()) {
            Element sensorElement = (Element)elemList.item(i);
            NamedNodeMap map = sensorElement.getAttributes();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            int j = 0;
            while (j < map.getLength()) {
                Node node = map.item(j);
                String name = node.getNodeName();
                String type = node.getTextContent();
                stringMap.put(name, type);
                ++j;
            }
            SensorSpecification credentials = new SensorSpecification(stringMap);
            AdaptorSpecificationParser.getProperties(sensorElement, map, credentials);
            adaptor.addSensor(credentials);
            ++i;
        }
    }

    private static void getOutput(AdaptorSpecification adaptor, NodeList elemList) {
        int i = 0;
        while (i < elemList.getLength()) {
            Element sensorElement = (Element)elemList.item(i);
            NamedNodeMap map = sensorElement.getAttributes();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            int j = 0;
            while (j < map.getLength()) {
                Node node = map.item(j);
                String name = node.getNodeName();
                String type = node.getTextContent();
                log.info(String.valueOf(name) + " " + type);
                stringMap.put(name, type);
                adaptor.addOutput(type);
                ++j;
            }
            ++i;
        }
    }

    private static void getProperties(Element sensorElement, NamedNodeMap map, SensorSpecification credentials) {
        NodeList properties = sensorElement.getChildNodes();
        int j = 0;
        while (j < properties.getLength()) {
            Node item = properties.item(j);
            String textContent = item.getTextContent();
            NamedNodeMap map2 = item.getAttributes();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            int k = 0;
            while (k < map.getLength()) {
                Node node = map2.item(k);
                String name = node.getNodeName();
                String type = node.getTextContent();
                stringMap.put(name, type);
                ++k;
            }
            Property property = new Property(stringMap, textContent);
            credentials.add(property);
            ++j;
        }
    }

    public static void main(String[] args) {
        String infoDesc = "<sensor type='twitter.info' id='0000000'><property name='sensorFrequency' type='Integer' /><property name='location' type='String' /><property name='latlong' type='String'/><property name='woeid' type='Integer' /><property name='keyword' type='String' /><property name='state' type='Boolean' /></sensor>";
        String trendDesc = "<sensor type='twitter.trend' id='0000000'><property name='sensorFrequency' type='Integer' /><property name='location' type='String' /><property name='latlong' type='String'/><property name='woeid' type='Integer' /><property name='state' type='Boolean' /></sensor>";
        String userDesc = "<sensor type='twitter.user' id='0000000'><property name='sensorFrequency' type='Integer' /><property name='userid' type='Long' /><property name='kloutscore' type='Double' /><property name='state' type='Boolean' /></sensor>";
        String cfr_ignored_0 = "<adaptorDescription name='twitter'>" + infoDesc + userDesc + trendDesc + "<output type='number'/></adaptorDescription>";
        AdaptorSpecification cred = AdaptorSpecificationParser.parse(infoDesc);
        log.info(cred.toString());
    }
}

