/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.sensor.data;

import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.data.DataModel;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SensorData
implements ISensorData,
Comparable<ISensorData> {
    private static final long serialVersionUID = -5746449440953212362L;
    private NodeDescription description;
    private String type;
    private String modality;
    private long time;
    private Map<String, String> values = new HashMap<String, String>();
    private String network = "default";

    public SensorData(String network, int id, String modality, Map<String, String> values, String type, long time) {
        this.values = values;
        this.modality = modality;
        this.description = new NodeDescription(id, network);
        this.type = type;
        this.time = time;
        this.network = network;
    }

    public SensorData(String network, int id, String modality, Map<String, String> values, String type, long time, DataModel model) {
        this.values = values;
        this.modality = modality;
        this.description = new NodeDescription(id, network);
        this.type = type;
        this.time = time;
        this.network = network;
    }

    public SensorData(String network, int id, String modality, Map<String, String> values, String type) {
        this(network, id, modality, values, type, System.currentTimeMillis());
    }

    public SensorData(String network, int id, String modality, String value, String type) {
        this(network, id, modality, value, type, System.currentTimeMillis());
    }

    public SensorData(String network, int id, String modality, String value, String type, long time) {
        this.description = new NodeDescription(id, network);
        this.modality = modality;
        this.values.put(modality, value);
        this.type = type;
        this.time = time;
        this.network = network;
    }

    @Override
    public String getReadingType() {
        return this.type;
    }

    @Override
    public String getSensedModality() {
        return this.modality;
    }

    @Override
    public String getValue() {
        Vector<String> list = new Vector<String>(this.values.keySet());
        return this.values.get(list.get(0));
    }

    @Override
    public int getID() {
        return this.description.getID();
    }

    @Override
    public long getTimestamp() {
        return this.time;
    }

    @Override
    public NodeDescription getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(NodeDescription description) {
        this.description = description;
    }

    public String toString() {
        if (this.isLinked()) {
            String ret = "Sensor Node: " + this.getID() + "\n";
            for (String key : this.values.keySet()) {
                ret = String.valueOf(ret) + key + ": " + this.values.get(key) + "\n";
            }
            return ret;
        }
        return "Sensor Node: " + this.getID() + " Modality: " + this.getSensedModality() + " Value: " + this.getValue() + " Type: " + this.type;
    }

    @Override
    public int compareTo(ISensorData o) {
        Long lon = this.time;
        return lon.compareTo(o.getTimestamp());
    }

    @Override
    public String toXML() {
        XStream xstream = new XStream();
        return xstream.toXML((Object)this);
    }

    @Override
    public String toJSON() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    @Override
    public String getValue(String arg) {
        return this.values.get(arg);
    }

    @Override
    public boolean isLinked() {
        return this.values.keySet().size() > 1;
    }

    @Override
    public List<String> getModalities() {
        return new Vector<String>(this.values.keySet());
    }

    public static ISensorData fromXML(String xml) {
        XStream xstream = new XStream();
        ISensorData data = (ISensorData)xstream.fromXML(xml);
        return data;
    }

    public static ISensorData fromJSON(String json) {
        Gson gson = new Gson();
        return (ISensorData)gson.fromJson(json, SensorData.class);
    }

    @Override
    public boolean isA(String modality) {
        return this.getSensedModality().equals(modality);
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    public void replaceValues(Map<String, String> newValues) {
        this.values = newValues;
    }
}

