/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.sensor;

import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SensorStatus;
import ie.ucd.sixth.core.adaptor.ISensorAdaptor;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.NodeDescription;
import ie.ucd.sixth.core.sensor.NodeProperty;
import ie.ucd.sixth.core.sensor.Sensor;
import ie.ucd.sixth.core.sensor.SensorDescription;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.SensorData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SensorNode
implements ISensorNode {
    private static final long serialVersionUID = -6497023023396497160L;
    private Map<String, ISensor> sensors = new HashMap<String, ISensor>();
    private int id;
    private ISensorAdaptor adaptor;
    private boolean timeoutRelevant = true;
    protected String state = SensorStatus.ON.toString();
    protected Long lastReplyTime = 0L;
    private String sensorType;
    protected Map<String, NodeProperty> properties = new HashMap<String, NodeProperty>();

    public SensorNode(NodeDescription desc, ISensorAdaptor adaptor) {
        this(desc, adaptor, "");
    }

    public SensorNode(NodeDescription desc, ISensorAdaptor adaptor, String sensorType) {
        this.adaptor = adaptor;
        this.id = desc.getID();
        this.sensorType = sensorType;
        this.properties.put("nodeState", new NodeProperty(SensorStatus.ON.toString()));
        this.properties.put("battery", new NodeProperty("active"));
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final synchronized List<ISensor> getSensors() {
        return new Vector<ISensor>(this.sensors.values());
    }

    @Override
    public ISensor getSensor(String modality) {
        return this.sensors.get(modality);
    }

    @Override
    public String getNetwork() {
        return this.getAdaptor().getInfo().getName();
    }

    @Override
    public boolean hasA(String modality) {
        return this.sensors.keySet().contains(modality);
    }

    public String toString() {
        return "Sensor Node " + this.getID();
    }

    @Override
    public ISensor sensorLookup(SensorDescription desc) {
        ISensor sensor = this.sensors.get(desc.getModality());
        if (sensor == null) {
            sensor = new Sensor(desc.getModality(), this);
            this.sensors.put(desc.getModality(), sensor);
            this.getAdaptor().notifyChange(this);
            this.getAdaptor().addSensor(sensor);
        }
        return sensor;
    }

    @Override
    public NodeDescription getDescription() {
        return new NodeDescription(this);
    }

    @Override
    public ISensorAdaptor getAdaptor() {
        return this.adaptor;
    }

    @Override
    public String toXML() {
        XStream xstream = new XStream();
        return xstream.toXML((Object)this.getDescription());
    }

    @Override
    public String toJSON() {
        Gson gson = new Gson();
        return gson.toJson((Object)this.getDescription());
    }

    @Override
    public void toggleTimeout(boolean state) {
        this.timeoutRelevant = state;
        for (ISensor sensor : this.sensors.values()) {
            sensor.toggleTimeout(state);
        }
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public Map<String, List<ISensorData>> getReadings() {
        HashMap<String, List<ISensorData>> map = new HashMap<String, List<ISensorData>>();
        for (ISensor sensor : this.sensors.values()) {
            map.put(sensor.getModality(), sensor.getReadings());
        }
        return map;
    }

    @Override
    public void setState(String state) {
        this.state = state;
        if (state.equals(SensorStatus.OFF.toString())) {
            RetaskingMsg message = RetaskingMsg.retask(this.getID(), state);
            this.getAdaptor().retask(message);
        }
    }

    @Override
    public void setTimeoutThreshold(long time) {
        for (ISensor sensor : this.sensors.values()) {
            sensor.setThreshold(time);
        }
    }

    @Override
    public boolean retask(RetaskingMsg message) {
        message.setNodeID(this.getID());
        return this.getAdaptor().retask(message);
    }

    @Override
    public void setLastReply(long timestamp) {
        this.lastReplyTime = timestamp;
    }

    @Override
    public Long getLastReplyTime() {
        return this.lastReplyTime;
    }

    @Override
    public List<ISensorData> getReadings(IQuery query) {
        Vector<ISensorData> list = new Vector<ISensorData>();
        for (ISensor sensor : this.sensors.values()) {
            list.addAll(query.matchesData(sensor.getReadings()));
        }
        return list;
    }

    @Override
    public List<RetaskingMsg.COMMANDTYPE> acceptedCommands() {
        return this.getAdaptor().acceptedCommands();
    }

    @Override
    public boolean accepts(RetaskingMsg.COMMANDTYPE command) {
        return this.getAdaptor().accepts(command);
    }

    @Override
    public String getSensorType() {
        return this.sensorType;
    }

    public static ISensorData clone(SensorData data) {
        SensorData clone;
        if (data.isLinked()) {
            HashMap<String, String> map = new HashMap<String, String>(data.getValues());
            clone = new SensorData(data.getNetwork(), data.getID(), data.getSensedModality(), map, data.getReadingType());
        } else {
            clone = new SensorData(data.getNetwork(), data.getID(), data.getSensedModality(), data.getValue(), data.getReadingType(), data.getTimestamp());
        }
        return clone;
    }

    @Override
    public NodeProperty getProperty(String key) {
        return this.properties.get(key);
    }
}

