/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.sensor;

import ie.ucd.sixth.core.sensor.ISensor;
import java.io.Serializable;

public class SensorDescription
implements Serializable {
    private static final long serialVersionUID = 530519884368335562L;
    private int nodeID;
    private String modality;
    private String status = "";
    private String adaptorName;

    public SensorDescription(ISensor sens) {
        this.nodeID = sens.getNode().getID();
        this.modality = sens.getModality();
        this.adaptorName = sens.getNode().getAdaptor().getType();
    }

    public SensorDescription(String modality, int id, String adaptorName) {
        this.nodeID = id;
        this.modality = modality;
        this.adaptorName = adaptorName;
    }

    public SensorDescription(SensorDescription sensor) {
        this.nodeID = sensor.getNodeID();
        this.modality = sensor.getModality();
        this.adaptorName = sensor.getAdaptorName();
    }

    public String getAdaptorName() {
        return this.adaptorName;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public String getModality() {
        return this.modality;
    }

    public String toString() {
        return "Sensor for " + this.getModality() + " Sensor Node: " + this.getNodeID();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }
}

