/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.sensor;

import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.IRetensionPolicy;
import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SensorStatus;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.SensorDescription;
import ie.ucd.sixth.core.sensor.SensorNode;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class Sensor
implements ISensor {
    private SensorNode node;
    private String modality;
    private List<ISensorData> readings;
    private Frequency samplingFrequency;
    private boolean timeoutRelevent = true;
    private Timer timer;
    private double threshold = 20000.0;

    public Sensor(String modality, SensorNode sensorNode) {
        this.node = sensorNode;
        this.modality = modality;
        this.readings = new Vector<ISensorData>();
        this.samplingFrequency = new Frequency(100.0, false);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new Task(this), (long)(this.samplingFrequency.getFreqMS() + this.threshold));
    }

    @Override
    public String getModality() {
        return this.modality;
    }

    @Override
    public List<ISensorData> getReadings() {
        return new Vector<ISensorData>(this.readings);
    }

    @Override
    public ISensorData getLastReading() {
        List<ISensorData> list = this.getReadings();
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public ISensorNode getNode() {
        return this.node;
    }

    @Override
    public boolean isA(String modality) {
        return modality.equals(modality);
    }

    @Override
    public synchronized void addData(ISensorData data) {
        if (this.timeoutRelevent) {
            this.timer.cancel();
        }
        this.readings.add(data);
        if (this.timeoutRelevent) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new Task(this), (long)(this.samplingFrequency.getFreqMS() + this.threshold));
        }
        this.getNode().setState(SensorStatus.ON.toString());
        this.getNode().setLastReply(data.getTimestamp());
    }

    @Override
    public List<ISensorData> getReadings(IQuery query) {
        Vector<ISensorData> matching = new Vector<ISensorData>();
        for (ISensorData data : this.getReadings()) {
            if (!query.match(data)) continue;
            matching.add(data);
        }
        return matching;
    }

    @Override
    public void setSamplingFrequency(Frequency freq) {
        this.samplingFrequency = freq;
    }

    @Override
    public Frequency getSamplingFrequency() {
        return this.samplingFrequency;
    }

    @Override
    public boolean retask(RetaskingMsg message) {
        message.setSensor(this.getModality());
        message.setNodeID(this.getNode().getID());
        return this.node.getAdaptor().retask(message);
    }

    public String toString() {
        return new SensorDescription(this).toString();
    }

    @Override
    public SensorDescription getDescription() {
        return new SensorDescription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Object obj) {
        if (obj instanceof IRetensionPolicy) {
            IRetensionPolicy policy = (IRetensionPolicy)obj;
            List<ISensorData> list = this.readings;
            synchronized (list) {
                this.readings = policy.filter(this.getReadings());
            }
        }
    }

    @Override
    public void toggleTimeout(boolean state) {
        this.timeoutRelevent = state;
        if (!this.timeoutRelevent) {
            this.timer.cancel();
        } else {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new Task(this), (long)(this.samplingFrequency.getFreqMS() + this.threshold));
        }
    }

    @Override
    public void setThreshold(long time) {
        this.threshold = time;
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new Task(this), (long)(this.samplingFrequency.getFreqMS() + this.threshold));
    }

    @Override
    public List<RetaskingMsg.COMMANDTYPE> acceptedCommands() {
        return this.getNode().acceptedCommands();
    }

    @Override
    public boolean accepts(RetaskingMsg.COMMANDTYPE command) {
        return this.getNode().accepts(command);
    }

    private class Task
    extends TimerTask {
        private Sensor sensor;

        public Task(Sensor sensor2) {
            this.sensor = sensor2;
        }

        @Override
        public void run() {
            this.sensor.getNode().setState(SensorStatus.TIMEOUT.toString());
            this.sensor.getNode().getAdaptor().notifyTimeout(this.sensor.getNode());
        }
    }
}

