/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.sensor;

import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import ie.ucd.sixth.core.adaptor.AdaptorInformation;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.SensorDescription;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class NodeDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int nodeID;
    private List<SensorDescription> sensors;
    private String network;
    private String nodeStatus;
    private AdaptorInformation adaptorInformation;
    private String sensorType;

    public NodeDescription(ISensorNode sensor) {
        this(sensor.getID(), sensor.getNetwork());
        this.sensors = new Vector<SensorDescription>();
        for (ISensor sens : sensor.getSensors()) {
            SensorDescription desc = new SensorDescription(sens);
            this.sensors.add(desc);
        }
        this.nodeStatus = sensor.getState();
        this.adaptorInformation = sensor.getAdaptor().getInfo();
        this.sensorType = sensor.getSensorType();
    }

    public NodeDescription(NodeDescription desc) {
        this.network = desc.getNetwork();
        this.nodeID = desc.getID();
        this.sensors = desc.getSensors();
        this.nodeStatus = desc.getStatus();
        this.adaptorInformation = desc.getAdaptorInformation();
        this.sensorType = desc.getSensorType();
    }

    public NodeDescription(int id, String networkType) {
        this(id, networkType, "");
    }

    public NodeDescription(int id, String networkType, String sensorType) {
        this.network = networkType;
        this.nodeID = id;
        this.sensors = new Vector<SensorDescription>();
        this.adaptorInformation = null;
        this.sensorType = sensorType;
    }

    public static NodeDescription fromJSON(String json) {
        Gson gson = new Gson();
        return (NodeDescription)gson.fromJson(json, NodeDescription.class);
    }

    public static NodeDescription fromXML(String xml) {
        XStream xstream = new XStream();
        NodeDescription sensor = (NodeDescription)xstream.fromXML(xml);
        return sensor;
    }

    public int getID() {
        return this.nodeID;
    }

    public List<SensorDescription> getSensors() {
        return this.sensors;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getStatus() {
        return this.nodeStatus;
    }

    public AdaptorInformation getAdaptorInformation() {
        return this.adaptorInformation;
    }

    public boolean equals(NodeDescription nodeDesc) {
        return this.nodeID == nodeDesc.getID() && this.network == nodeDesc.getNetwork();
    }

    public String toString() {
        return "Sensor Node: " + this.nodeID + " Type: " + this.network.toUpperCase();
    }

    public void setStatus(String type) {
        this.nodeStatus = type;
    }

    public void setSensorType(String type) {
        this.sensorType = type;
    }

    public String getSensorType() {
        return this.sensorType;
    }
}

