/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.query.parser;

import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.query.AllQuery;
import ie.ucd.sixth.core.query.ComparisonQuery;
import ie.ucd.sixth.core.query.ConjugateQuery;
import ie.ucd.sixth.core.query.Duration;
import ie.ucd.sixth.core.query.IDQuery;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.query.LocationQuery;
import ie.ucd.sixth.core.query.ModalityQuery;
import ie.ucd.sixth.core.query.NumberQuery;
import ie.ucd.sixth.core.query.TypeQuery;
import ie.ucd.sixth.core.query.parser.QueryParserVisitor;
import ie.ucd.sixth.core.query.parser.SimpleNode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueryVisitor
implements QueryParserVisitor {
    ModalityQuery SelectQueries = null;
    ConjugateQuery con = null;
    List<IQuery> conjugates = new LinkedList<IQuery>();
    Duration duration = null;

    @Override
    public Object visit(SimpleNode node, Object data) {
        if (node.toString().equals("Start")) {
            this.visit((SimpleNode)node.jjtGetChild(0), null);
        } else if (node.toString().equals("Query")) {
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                this.visit((SimpleNode)node.jjtGetChild(i), null);
                ++i;
            }
        } else if (node.toString().equals("Select")) {
            if (node.jjtGetNumChildren() > 0) {
                HashMap<String, Frequency> modQueries = new HashMap<String, Frequency>();
                int i = 0;
                while (i < node.jjtGetNumChildren()) {
                    this.visit((SimpleNode)node.jjtGetChild(i), modQueries);
                    ++i;
                }
                this.SelectQueries = new ModalityQuery(modQueries);
            }
        } else if (node.toString().equals("Where")) {
            if (node.jjtGetNumChildren() > 0) {
                this.visit((SimpleNode)node.jjtGetChild(0), null);
            }
        } else if (node.toString().equals("For")) {
            if (node.jjtGetNumChildren() > 0) {
                this.visit((SimpleNode)node.jjtGetChild(0), data);
            }
        } else if (node.toString().equals("Duration")) {
            String unit = (String)this.visit((SimpleNode)node.jjtGetChild(0), data);
            this.duration = new Duration(Integer.parseInt((String)node.jjtGetValue()), unit);
        } else {
            if (node.toString().equals("Unit")) {
                return node.jjtGetValue();
            }
            if (node.toString().equals("Identifier")) {
                return node.jjtGetValue();
            }
            if (node.toString().equals("Conjugate")) {
                int i = 0;
                while (i < node.jjtGetNumChildren()) {
                    this.visit((SimpleNode)node.jjtGetChild(i), null);
                    ++i;
                }
            } else {
                if (node.toString().equals("Aggregate")) {
                    LinkedList<IQuery> aggregates = new LinkedList<IQuery>();
                    int i = 0;
                    while (i < node.jjtGetNumChildren()) {
                        Object o = this.visit((SimpleNode)node.jjtGetChild(i), null);
                        aggregates.add((IQuery)o);
                        ++i;
                    }
                    return aggregates;
                }
                if (node.toString().equals("Term")) {
                    return this.visit((SimpleNode)node.jjtGetChild(0), null);
                }
                if (node.toString().equals("Equal")) {
                    String identifier = (String)this.visit((SimpleNode)node.jjtGetChild(0), null);
                    String operator = (String)this.visit((SimpleNode)node.jjtGetChild(1), null);
                    double number = Double.parseDouble((String)node.jjtGetValue());
                    return new ComparisonQuery(identifier, number, operator);
                }
                if (node.toString().equals("Modality")) {
                    String cond = null;
                    if (node.jjtGetNumChildren() > 0) {
                        cond = (String)this.visit((SimpleNode)node.jjtGetChild(0), data);
                        String unit = cond.split(",")[1];
                        String value = cond.split(",")[0];
                        Frequency f = null;
                        if (unit.equals("Hz")) {
                            f = new Frequency(Double.parseDouble(value), true);
                        } else if (unit.equals("ms")) {
                            f = new Frequency(Double.parseDouble(value), false);
                        }
                        ((Map)data).put((String)node.jjtGetValue(), f);
                    } else {
                        ((Map)data).put((String)node.jjtGetValue(), null);
                    }
                } else {
                    if (node.toString().equals("Frequency")) {
                        return node.jjtGetValue();
                    }
                    if (node.toString().equals("KeyWordsEQ")) {
                        String key = (String)this.visit((SimpleNode)node.jjtGetChild(0), null);
                        String id = (String)this.visit((SimpleNode)node.jjtGetChild(1), null);
                        if (key.equals("ID")) {
                            LinkedList<String> l = new LinkedList<String>();
                            l.add(id);
                            return new IDQuery(l);
                        }
                        if (key.equals("SENSOR_TYPE")) {
                            return new TypeQuery(id);
                        }
                        if (key.equals("DATA_TYPE")) {
                            if (id.equalsIgnoreCase("number")) {
                                return new NumberQuery();
                            }
                            if (id.equalsIgnoreCase("string")) {
                                return new AllQuery();
                            }
                        } else if (key.equals("LOCATION")) {
                            return new LocationQuery(id);
                        }
                    } else {
                        if (node.toString().equals("Keyword")) {
                            return node.jjtGetValue();
                        }
                        if (node.toString().equals("ModalityWhere")) {
                            return new ModalityQuery((String)node.jjtGetValue());
                        }
                        if (node.toString().equals("Comparisons")) {
                            return node.jjtGetValue();
                        }
                    }
                }
            }
        }
        return null;
    }

    public ModalityQuery getModQ() {
        return this.SelectQueries;
    }

    public ConjugateQuery getConQ() {
        return new ConjugateQuery(this.conjugates);
    }

    public Duration getDuration() {
        return this.duration;
    }
}

