/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.query;

import ie.ucd.sixth.core.query.AbstractQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.Map;

public class SensorDataQuery
extends AbstractQuery {
    private static final long serialVersionUID = 1L;
    private static final String TIMESTAMP = "timestamp";
    private static final String MODALITY = "modality";
    private static final String SENSOR = "sensor";
    private Map<String, String> criteria;
    private boolean all;
    private ISensorData sensor;

    public SensorDataQuery(ISensorData data, Map<String, String> criteria, boolean all) {
        this.sensor = data;
        this.criteria = criteria;
        this.all = all;
    }

    public SensorDataQuery(ISensorData data, Map<String, String> criteria) {
        this(data, criteria, false);
    }

    @Override
    public boolean match(ISensorNode sensor) {
        return false;
    }

    @Override
    public boolean match(ISensor sensor2) {
        return false;
    }

    public boolean check(String key, ISensorData data) {
        if (key.equals(MODALITY)) {
            return data.getSensedModality() == this.sensor.getSensedModality();
        }
        if (key.equals(SENSOR)) {
            return data.getID() == this.sensor.getID();
        }
        return false;
    }

    @Override
    public boolean match(ISensorData data) {
        int size = this.criteria.keySet().size();
        int counter = 0;
        for (String key : this.criteria.keySet()) {
            boolean match = this.check(key, data);
            if (this.all && !match) {
                return false;
            }
            if (this.all) {
                ++counter;
                continue;
            }
            if (!match) continue;
            return true;
        }
        return size == counter;
    }
}

