/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.query;

import ie.ucd.sixth.core.query.AbstractQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberQuery
extends AbstractQuery {
    private static final long serialVersionUID = 1300943448253721456L;
    private static final Pattern pattern = Pattern.compile("^(\\d+\\.{0,1}\\d{0,})$");

    @Override
    public boolean match(ISensor sensor) {
        ISensorData data = sensor.getLastReading();
        return this.match(data);
    }

    @Override
    public boolean match(ISensorData data) {
        if (data.isLinked()) {
            for (String modality : data.getModalities()) {
                String val = data.getValue(modality);
                Matcher matcher = pattern.matcher(val);
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }
        String val = data.getValue();
        Matcher matcher = pattern.matcher(val);
        return matcher.find();
    }

    public String toString() {
        return "NumberQuery";
    }
}

