/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.query;

import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.query.AbstractQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.HashMap;
import java.util.Map;

public class ModalityQuery
extends AbstractQuery {
    private static final long serialVersionUID = 3411523644998366159L;
    private Map<String, Frequency> modalities;

    public ModalityQuery(Map<String, Frequency> modalities) {
        this.modalities = modalities;
    }

    public ModalityQuery(String temperature) {
        this(new HashMap<String, Frequency>());
        this.modalities.put(temperature, null);
    }

    @Override
    public boolean match(ISensor sensor2) {
        for (String modality : this.modalities.keySet()) {
            if (!modality.equals(sensor2.getModality())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean match(ISensorData data) {
        for (String modality : this.modalities.keySet()) {
            if (!modality.equals(data.getSensedModality())) continue;
            return true;
        }
        return false;
    }

    public Map<String, Frequency> getRequirements() {
        return this.modalities;
    }

    public String toString() {
        String ret = "ModalityQuery\n";
        for (String s : this.modalities.keySet()) {
            ret = this.modalities.get(s) != null ? String.valueOf(ret) + "\t" + s + " @ " + this.modalities.get(s).getFreqHertz() + " Hz\n" : String.valueOf(ret) + "\t" + s + "\n";
        }
        return ret;
    }
}

