/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.query;

import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.query.ConjugateQuery;
import ie.ucd.sixth.core.query.Duration;
import ie.ucd.sixth.core.query.IRealTimeQuery;
import ie.ucd.sixth.core.query.ModalityQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.ISensorNode;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GeneratedQuery
implements IRealTimeQuery {
    private static final long serialVersionUID = -1725458781263265797L;
    private ModalityQuery selectQuery;
    private ConjugateQuery whereQuery;
    private Duration duration;

    public GeneratedQuery(ModalityQuery mq, ConjugateQuery wq, Duration d) {
        this.selectQuery = mq;
        this.whereQuery = wq;
        this.duration = d;
    }

    @Override
    public boolean match(ISensorNode sensor) {
        return this.selectQuery.match(sensor);
    }

    @Override
    public boolean match(ISensor sensor2) {
        return this.selectQuery.match(sensor2);
    }

    @Override
    public boolean match(ISensorData data) {
        return this.selectQuery.match(data) && this.whereQuery.match(data);
    }

    @Override
    public List<ISensorNode> matches(List<ISensorNode> sensors) {
        LinkedList<ISensorNode> list = new LinkedList<ISensorNode>();
        for (ISensorNode iSensor : sensors) {
            if (!this.selectQuery.match(iSensor) || !this.whereQuery.match(iSensor)) continue;
            list.add(iSensor);
        }
        return list;
    }

    @Override
    public Map<String, Frequency> getRequirements() {
        return this.selectQuery.getRequirements();
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public ConjugateQuery getConditional() {
        return this.whereQuery;
    }

    @Override
    public ModalityQuery getModalityQueries() {
        return this.selectQuery;
    }

    public String toString() {
        String ret = "SELECT\n" + this.selectQuery.toString() + "\n";
        if (this.whereQuery != null) {
            ret = String.valueOf(ret) + "WHERE " + this.whereQuery.toString() + "\n";
        }
        if (this.duration != null) {
            ret = String.valueOf(ret) + "FOR " + this.duration + "\n";
        }
        return ret;
    }

    @Override
    public List<ISensorData> matchesData(List<ISensorData> dataList) {
        LinkedList<ISensorData> list = new LinkedList<ISensorData>();
        for (ISensorData data : dataList) {
            if (!this.match(data)) continue;
            list.add(data);
        }
        return list;
    }
}

