/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.query;

import ie.ucd.sixth.core.query.AbstractQuery;
import ie.ucd.sixth.core.sensor.ISensor;
import ie.ucd.sixth.core.sensor.data.ISensorData;

public class ComparisonQuery
extends AbstractQuery {
    private static final long serialVersionUID = 7004840396758418915L;
    private double value;
    private String modality;
    private ComparisonOperator operator;

    private String CO(byte b) {
        switch (b) {
            case 1: {
                return ">";
            }
            case 0: {
                return "<";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return "=<";
            }
            case 4: {
                return "=>";
            }
        }
        return null;
    }

    public ComparisonQuery(String mod, double val, String op) {
        this.value = val;
        this.modality = mod;
        this.operator = new ComparisonOperator(op);
    }

    @Override
    public boolean match(ISensor sensor2) {
        ISensorData data = sensor2.getLastReading();
        return this.operator.matches(this.value, Double.parseDouble(data.getValue())) && sensor2.getModality().equals(this.modality);
    }

    @Override
    public boolean match(ISensorData data) {
        return this.operator.matches(this.value, Double.parseDouble(data.getValue())) && data.getSensedModality().equals(this.modality);
    }

    public String toString() {
        return "Comparison " + this.modality + " " + this.CO(this.operator.operator) + " " + this.value;
    }

    private class ComparisonOperator {
        private static final byte LESS_THAN = 0;
        private static final byte GREATER_THAN = 1;
        private static final byte EQUAL = 2;
        private static final byte LESS_THAN_EQUAL = 3;
        private static final byte GREATER_THAN_EQUAL = 4;
        private byte operator;

        public ComparisonOperator(String op) {
            if (op.equals("<")) {
                this.operator = 0;
            } else if (op.equals(">")) {
                this.operator = 1;
            } else if (op.equals("=")) {
                this.operator = (byte)2;
            } else if (op.equals("=<")) {
                this.operator = (byte)3;
            } else if (op.equals("=>")) {
                this.operator = (byte)4;
            }
        }

        public boolean matches(double value, double number) {
            switch (this.operator) {
                case 0: {
                    return value > number;
                }
                case 1: {
                    return value < number;
                }
                case 2: {
                    return value == number;
                }
                case 3: {
                    return value <= number;
                }
                case 4: {
                    return value >= number;
                }
            }
            return false;
        }
    }
}

