/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.notification;

import ie.ucd.sixth.core.notification.INotifiable;
import ie.ucd.sixth.core.notification.INotifier;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.receiver.IDataReceiver;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Notifier
implements INotifier {
    protected IQuery query;
    protected INotifiable notifiable;
    protected boolean send = true;
    protected ServiceRegistration<IDataReceiver> registration;
    protected BundleContext context;

    public Notifier(IQuery query, INotifiable notifiable, BundleContext context) {
        this.query = query;
        this.notifiable = notifiable;
        this.registration = context.registerService(IDataReceiver.class, (Object)this, null);
        this.context = context;
    }

    @Override
    public void resume() {
        this.send = true;
    }

    @Override
    public void stop() {
        this.send = false;
    }

    @Override
    public void receive(ISensorData data) {
        if (this.send && this.query.match(data)) {
            this.notifiable.receive(data, this.query);
        }
    }

    @Override
    public void setQuery(IQuery query) {
        this.query = query;
    }

    @Override
    public void setNotifiable(INotifiable notifiable) {
        this.notifiable = notifiable;
    }

    @Override
    public void unregister() {
        this.registration.unregister();
    }

    @Override
    public String getCredentials() {
        return "pass";
    }
}

