/*
 * Decompiled with CFR 0.152.
 */
package ie.ucd.sixth.core.notification;

import ie.ucd.sixth.core.Frequency;
import ie.ucd.sixth.core.RetaskingMsg;
import ie.ucd.sixth.core.SIXTH;
import ie.ucd.sixth.core.adaptor.IAdaptor;
import ie.ucd.sixth.core.discovery.IDiscovery;
import ie.ucd.sixth.core.discovery.IDiscoveryHandler;
import ie.ucd.sixth.core.notification.INotifiable;
import ie.ucd.sixth.core.notification.Notifier;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.query.IRealTimeQuery;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import java.util.Timer;
import java.util.TimerTask;
import org.osgi.framework.BundleContext;

public class BetterNotifier
extends Notifier {
    private IRealTimeQuery rtquery;
    private int index = 0;
    private Timer timer;
    private boolean timed;

    public BetterNotifier(IRealTimeQuery query, INotifiable notifiable, BundleContext context) {
        super(query, notifiable, context);
        this.rtquery = query;
        this.setup();
        this.timer = new Timer();
        this.timed = this.rtquery.getDuration().isTimeBased();
        if (this.timed) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BetterNotifier.this.halt();
                }
            }, this.rtquery.getDuration().getMillis());
        }
    }

    private void setup() {
        IDiscoveryHandler handler = SIXTH.getDiscoveryHandler();
        IDiscovery disc = handler.getDiscovery("pass");
        for (IAdaptor iAdaptor : disc.getLocalNode().getSensorAdaptors()) {
            for (String key : this.rtquery.getRequirements().keySet()) {
                Frequency freq = this.rtquery.getRequirements().get(key);
                RetaskingMsg message = RetaskingMsg.setSamplingFrequency(key, freq);
                iAdaptor.retask(message);
            }
        }
    }

    @Override
    public void receive(ISensorData data) {
        super.receive(data);
        ++this.index;
        if (this.rtquery.getDuration() != null && !this.timed && this.index > this.rtquery.getDuration().getSampleSize()) {
            this.halt();
        }
    }

    private void halt() {
        this.notifiable.receive("Complete", (IQuery)this.rtquery);
        this.stop();
        this.unregister();
        this.timer.cancel();
        this.timer = null;
    }
}

